/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.FileDialog;

public class KontoauszugSave
implements Action {
    private static final Settings SETTINGS = new Settings(KontoauszugSave.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof Kontoauszug)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den zu speichernden Kontoauszug"));
        }
        Kontoauszug k = (Kontoauszug)context;
        try {
            String s;
            FileDialog fd = new FileDialog(GUI.getShell(), 8192);
            fd.setText(i18n.tr("Bitte geben Sie eine Datei ein, in der der Kontoauszug gespeichert werden soll."));
            fd.setOverwrite(true);
            String name = k.getDateiname();
            if (name == null || name.length() == 0) {
                String s2 = KontoauszugPdfUtil.createPath(k.getKonto(), k);
                File f = new File(s2);
                name = f.getName();
            }
            fd.setFileName(name);
            String path = SETTINGS.getString("lastdir", System.getProperty("user.home"));
            if (path != null && path.length() > 0) {
                fd.setFilterPath(path);
            }
            if ((s = fd.open()) == null || s.length() == 0) {
                throw new OperationCanceledException();
            }
            File file = new File(s);
            SETTINGS.setAttribute("lastdir", file.getParent());
            KontoauszugPdfUtil.store(k, file);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Kontoauszug gespeichert"), 0));
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to save file", (Throwable)re);
            throw new ApplicationException(i18n.tr("Speichern des Kontoauszuges fehlgeschlagen: {0}", re.getMessage()));
        }
    }
}

