/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.Open;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class OpenReminderTemplate
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof HibiscusDBObject)) {
            return;
        }
        try {
            HibiscusDBObject object = (HibiscusDBObject)context;
            String id = MetaKey.REMINDER_TEMPLATE.get(object);
            if (id == null) {
                return;
            }
            DBObject o = Settings.getDBService().createObject(object.getClass(), id);
            new Open().handleAction(o);
        }
        catch (ObjectNotFoundException oe) {
            throw new ApplicationException(i18n.tr("Datensatz nicht gefunden"));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to open template", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()));
        }
    }
}

