/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passport.PassportChangeRequest;
import de.willuhn.jameica.hbci.passports.pintan.server.PassportImpl;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.structures.Konto;

public class PassportChange
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        boolean changeUserId;
        if (!(context instanceof PassportChangeRequest)) {
            Logger.error((String)("expected object type PassportChangeRequest but was " + context));
            return;
        }
        PassportChangeRequest pcr = (PassportChangeRequest)context;
        if (pcr.passport == null) {
            Logger.error((String)"no passport given");
            return;
        }
        String custOld = pcr.passport.getCustomerId();
        String userOld = pcr.passport.getUserId();
        boolean changeCustId = StringUtils.trimToNull((String)pcr.custId) != null && !StringUtils.trimToEmpty((String)custOld).equals(StringUtils.trimToEmpty((String)pcr.custId));
        boolean bl = changeUserId = StringUtils.trimToNull((String)pcr.userId) != null && !StringUtils.trimToEmpty((String)userOld).equals(StringUtils.trimToEmpty((String)pcr.userId));
        if (!changeCustId && !changeUserId) {
            return;
        }
        boolean changed = false;
        try {
            Properties upd;
            Logger.info((String)"applying new customerId/userId to passport");
            if (changeCustId) {
                Logger.info((String)"applying new customerId to passport");
                pcr.passport.setCustomerId(pcr.custId);
                changed = true;
            }
            if (changeUserId) {
                Logger.info((String)"applying new userId to passport");
                pcr.passport.setUserId(pcr.userId);
                changed = true;
            }
            if ((upd = pcr.passport.getUPD()) != null) {
                Enumeration<Object> e = upd.keys();
                int count = 0;
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = upd.getProperty(key);
                    if (value == null || value.length() == 0) continue;
                    if (changeCustId && value.equals(custOld)) {
                        Logger.info((String)("updating UPD entry " + key + " with new customerId"));
                        upd.setProperty(key, pcr.custId);
                        ++count;
                        continue;
                    }
                    if (!changeUserId || !value.equals(userOld)) continue;
                    Logger.info((String)("updating UPD entry " + key + " with new userId"));
                    upd.setProperty(key, pcr.userId);
                    ++count;
                }
                Logger.info((String)("updated " + count + " entries in UPD"));
                changed |= count > 0;
            }
            if (changed) {
                Logger.info((String)"saving changed passport");
                pcr.passport.saveChanges();
            }
            int count = 0;
            Konto[] konten = pcr.passport.getAccounts();
            if (konten != null && konten.length > 0) {
                Konto[] kontoArray = konten;
                int n = konten.length;
                int n2 = 0;
                while (n2 < n) {
                    Konto konto = kontoArray[n2];
                    de.willuhn.jameica.hbci.rmi.Konto k = Converter.HBCIKonto2HibiscusKonto(konto, PassportImpl.class);
                    if (!k.isNewObject()) {
                        if (changeCustId) {
                            Logger.info((String)("updating customerid in account ID " + k.getID()));
                            k.setKundennummer(pcr.custId);
                            k.store();
                            k.addToProtokoll(i18n.tr("Ge\u00e4nderte Kundenkennung - neu: {0}, alt: {1}", new String[]{pcr.custId, custOld}), 1);
                            ++count;
                        }
                        if (changeUserId) {
                            k.addToProtokoll(i18n.tr("Ge\u00e4nderte Benutzerkennung - neu: {0}, alt: {1}", new String[]{pcr.userId, userOld}), 1);
                        }
                    }
                    ++n2;
                }
            }
            Logger.info((String)("updated customerId in " + count + " accounts"));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Ge\u00e4nderte Zugangsdaten erfolgreich \u00fcbernommen"), 0));
        }
        catch (Exception e) {
            Logger.error((String)"error while applying new user-/customer data", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der ge\u00e4nderten Zugangsdaten: {0}", e.getMessage()), 1));
        }
    }
}

