/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.DBPropertyUtil;
import de.willuhn.jameica.hbci.server.VersionUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Set;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class PassportDeleteBPD
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof AbstractHBCIPassport)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Bank-Zugang aus."));
        }
        AbstractHBCIPassport passport = (AbstractHBCIPassport)context;
        Logger.info((String)"deleting BPD");
        passport.clearBPD();
        Logger.info((String)"mark sys id to be synced");
        passport.syncSysId();
        Properties upd = passport.getUPD();
        if (upd != null) {
            Logger.info((String)"setting UPD version to 0");
            upd.setProperty("UPA.version", "0");
        }
        passport.saveChanges();
        Logger.info((String)"deleting bpd/upd caches for user ids");
        Set<String> customerIds = HBCIProperties.getCustomerIDs((HBCIPassport)passport);
        for (String customerId : customerIds) {
            try {
                DBPropertyUtil.deleteScope(DBPropertyUtil.Prefix.BPD, customerId);
                DBPropertyUtil.deleteScope(DBPropertyUtil.Prefix.UPD, customerId);
            }
            catch (Exception e) {
                Logger.error((String)"error while clearing BPD/UPD cache", (Throwable)e);
            }
        }
        Logger.info((String)"deleting stored bpd/upd version numbers");
        String user = passport.getUserId();
        if (user != null && user.length() > 0) {
            try {
                VersionUtil.delete(Settings.getDBService(), String.valueOf(DBPropertyUtil.Prefix.BPD.value()) + "." + user);
            }
            catch (RemoteException re) {
                Logger.error((String)"error while deleting bpd cache", (Throwable)re);
            }
            try {
                VersionUtil.delete(Settings.getDBService(), String.valueOf(DBPropertyUtil.Prefix.UPD.value()) + "." + user);
            }
            catch (RemoteException re) {
                Logger.error((String)"error while deleting upd cache", (Throwable)re);
            }
            Logger.info((String)"mark upd/bpd caches expired");
            BPDUtil.expireCache((HBCIPassport)passport, DBPropertyUtil.Prefix.BPD);
            BPDUtil.expireCache((HBCIPassport)passport, DBPropertyUtil.Prefix.UPD);
        }
    }
}

