/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.PassportChange;
import de.willuhn.jameica.hbci.passport.PassportChangeRequest;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.kapott.hbci.passport.AbstractHBCIPassport;

public class PassportProcessCode3072
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof AbstractHBCIPassport)) {
            Logger.warn((String)("expected object type AbstractHBCIPassport but was " + context));
            return;
        }
        AbstractHBCIPassport hbciPassport = (AbstractHBCIPassport)context;
        Object o = hbciPassport.getPersistentData("hibiscus.context.userid.changed");
        if (o == null) {
            Logger.debug((String)"no changed customer data in persistent data of passport found");
            return;
        }
        try {
            String changes = o.toString();
            int pos = changes.indexOf("|");
            if (pos == -1) {
                Logger.warn((String)"changes did not contain userId|custId");
                return;
            }
            String userId = changes.substring(0, pos);
            String custId = changes.substring(pos + 1);
            if (userId.length() == 0) {
                Logger.warn((String)"no userId found");
                return;
            }
            if (custId.length() == 0) {
                Logger.warn((String)"no custId found");
                return;
            }
            String custOld = hbciPassport.getCustomerId();
            String userOld = hbciPassport.getUserId();
            String text = i18n.tr("Die Bank hat mitgeteilt, dass sich die Benutzer- und Kundenkennung Ihres\nBank-Zugangs ge\u00e4ndert hat. Die neuen Zugangsdaten lauten:\n\n  Alte Kundenkennung: {0}\n  Neue Kundenkennung: {1}\n\n  Alte Benutzerkennung: {2}\n  Neue Benutzerkennung: {3}\n\nM\u00f6chten Sie die ge\u00e4nderten Zugangsdaten jetzt \u00fcbernehmen?");
            boolean b = Application.getCallback().askUser(text, new String[]{custOld, custId, userOld, userId});
            if (!b) {
                Logger.warn((String)"user cancelled request to change userId/customerId");
                return;
            }
            try {
                PassportChangeRequest pcr = new PassportChangeRequest(hbciPassport, custId, userId);
                new PassportChange().handleAction(pcr);
            }
            catch (Exception e) {
                Logger.error((String)"error while applying new user-/customer data", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der ge\u00e4nderten Zugangsdaten: {0}", e.getMessage()), 1));
            }
        }
        finally {
            hbciPassport.setPersistentData("hibiscus.context.userid.changed", null);
        }
    }
}

