/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.manager.HBCIUtils;

public class SepaConvertAddress
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        ArrayList<HibiscusAddress> list = new ArrayList<HibiscusAddress>();
        if (context instanceof HibiscusAddress) {
            list.add((HibiscusAddress)context);
        } else if (context instanceof HibiscusAddress[]) {
            list.addAll(Arrays.asList((HibiscusAddress[])context));
        }
        if (list.size() == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie mindestens eine Adresse aus"));
        }
        try {
            String q = i18n.tr("Hierbei werden bei allen ausgew\u00e4hlten Adressen die IBAN und BIC\nanhand der Kontonummer und BLZ errechnet und vervollst\u00e4ndigt,\ninsofern diese nicht bereits eingetragen sind.\n\nVorgang fortsetzen?");
            if (!Application.getCallback().askUser(q)) {
                return;
            }
        }
        catch (OperationCanceledException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error((String)"error while asking user", (Throwable)e);
            return;
        }
        int count = 0;
        Logger.info((String)("auto-completing iban/bic for " + list.size() + " selected addresses"));
        for (HibiscusAddress a : list) {
            try {
                String blz = StringUtils.trimToNull((String)a.getBlz());
                String bic = StringUtils.trimToNull((String)a.getBic());
                String kto = StringUtils.trimToNull((String)a.getKontonummer());
                String iban = StringUtils.trimToNull((String)a.getIban());
                if (bic != null && iban != null || blz == null || blz.length() != HBCIProperties.HBCI_BLZ_LENGTH) continue;
                String newBic = null;
                if (kto != null && iban == null) {
                    IBAN newIban = HBCIProperties.getIBAN(blz, kto);
                    newBic = newIban.getBIC();
                    a.setIban(newIban.getIBAN());
                }
                if (bic == null) {
                    if (newBic == null) {
                        newBic = HBCIUtils.getBICForBLZ((String)blz);
                    }
                    a.setBic(newBic);
                }
                a.store();
                Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)a));
                ++count;
            }
            catch (ApplicationException ae) {
                Logger.warn((String)("unable to complete IBAN/BIC: " + ae.getMessage()));
            }
            catch (Exception e) {
                Logger.error((String)"unable to auto-complete IBAN/BIC", (Throwable)e);
            }
        }
        Logger.info((String)("auto-completed addresses: " + count));
        if (count > 0) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("IBAN/BIC errechnet f\u00fcr {0} Adressen", Integer.toString(count)), 0));
        }
    }
}

