/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.BaseDauerauftragDeleteDialog;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragDelete;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SepaDauerauftragDelete
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof SepaDauerauftrag)) {
            throw new ApplicationException(i18n.tr("Kein SEPA-Dauerauftrag ausgew\u00e4hlt"));
        }
        final SepaDauerauftrag da = (SepaDauerauftrag)context;
        try {
            final CheckboxInput check = new CheckboxInput(true);
            YesNoDialog d = new YesNoDialog(1){

                protected void extend(Container container) throws Exception {
                    if (da.isActive()) {
                        final LabelInput warn = new LabelInput("");
                        warn.setColor(Color.COMMENT);
                        check.addListener(new Listener(){

                            public void handleEvent(Event event) {
                                Boolean b = (Boolean)check.getValue();
                                if (b.booleanValue()) {
                                    warn.setValue((Object)"");
                                } else {
                                    warn.setValue((Object)i18n.tr("Auftrag wird nur lokal gel\u00f6scht, bei der Bank bleibt er erhalten."));
                                }
                            }
                        });
                        container.addCheckbox(check, this.i18n.tr("Auftrag auch bei der Bank l\u00f6schen."));
                        container.addLabelPair("", (Input)warn);
                    }
                    super.extend(container);
                }
            };
            d.setTitle(i18n.tr("SEPA-Dauerauftrag l\u00f6schen"));
            d.setText(i18n.tr("Wollen Sie diesen Dauerauftrag wirklich l\u00f6schen?"));
            d.setSize(350, -1);
            Boolean choice = (Boolean)d.open();
            if (!choice.booleanValue()) {
                return;
            }
            if (da.isActive() && ((Boolean)check.getValue()).booleanValue()) {
                BaseDauerauftragDeleteDialog d2 = new BaseDauerauftragDeleteDialog(1);
                Date date = (Date)d2.open();
                Konto konto = da.getKonto();
                Class<SynchronizeJobSepaDauerauftragDelete> type = SynchronizeJobSepaDauerauftragDelete.class;
                BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
                SynchronizeBackend backend = engine.getBackend(type, konto);
                SynchronizeJob job = (SynchronizeJob)backend.create(type, konto);
                job.setContext("ctx.entity", da);
                job.setContext("ctx.da.delete.date", date);
                backend.execute(Arrays.asList(job));
            } else {
                da.delete();
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("SEPA-Dauerauftrag lokal gel\u00f6scht."), 0));
            }
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while deleting", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim L\u00f6schen des Auftrages: {0}", e.getMessage()));
        }
    }
}

