/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.SepaDauerauftragDialog;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragStore;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Arrays;

public class SepaDauerauftragExecute
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof SepaDauerauftrag)) {
            throw new ApplicationException(i18n.tr("Kein SEPA-Dauerauftrag angegeben"));
        }
        try {
            SepaDauerauftrag d = (SepaDauerauftrag)context;
            SepaDauerauftragDialog dd = new SepaDauerauftragDialog(d, 1);
            try {
                if (!((Boolean)dd.open()).booleanValue()) {
                    return;
                }
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)oce.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while showing confirm dialog", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausf\u00fchren des SEPA-Dauerauftrages"), 1));
                return;
            }
            Konto konto = d.getKonto();
            Class<SynchronizeJobSepaDauerauftragStore> type = SynchronizeJobSepaDauerauftragStore.class;
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
            SynchronizeBackend backend = engine.getBackend(type, konto);
            SynchronizeJob job = (SynchronizeJob)backend.create(type, konto);
            job.setContext("ctx.entity", d);
            backend.execute(Arrays.asList(job));
        }
        catch (RemoteException e) {
            Logger.error((String)"error while executing dauerauftrag", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Ausf\u00fchren des SEPA-Dauerauftrag"));
        }
    }
}

