/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.SepaLastschriftDialog;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Arrays;

public class SepaLastschriftExecute
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof SepaLastschrift)) {
            throw new ApplicationException(i18n.tr("Kein Auftrag angegeben"));
        }
        try {
            SepaLastschrift u = (SepaLastschrift)context;
            if (u.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Lastschrift wurde bereits ausgef\u00fchrt"));
            }
            if (u.isNewObject()) {
                u.store();
            }
            SepaLastschriftDialog d = new SepaLastschriftDialog(u, 1);
            try {
                if (!((Boolean)d.open()).booleanValue()) {
                    return;
                }
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)oce.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while showing confirm dialog", (Throwable)e);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Ausf\u00fchren des Auftrages"));
                return;
            }
            Konto konto = u.getKonto();
            Class<SynchronizeJobSepaLastschrift> type = SynchronizeJobSepaLastschrift.class;
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
            SynchronizeBackend backend = engine.getBackend(type, konto);
            SynchronizeJob job = (SynchronizeJob)backend.create(type, konto);
            job.setContext("ctx.entity", u);
            backend.execute(Arrays.asList(job));
        }
        catch (RemoteException e) {
            Logger.error((String)"error while executing transfer", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausf\u00fchren des Auftrages"), 1));
        }
    }
}

