/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.SepaLastschriftMerger;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;
import java.util.List;

public class SepaLastschriftMerge
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        boolean skip;
        if (!(context instanceof SepaLastschrift) && !(context instanceof SepaLastschrift[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Auftr\u00e4ge aus"));
        }
        SepaLastschrift[] source = null;
        source = context instanceof SepaLastschrift ? new SepaLastschrift[]{(SepaLastschrift)context} : (SepaLastschrift[])context;
        if (source.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Auftr\u00e4ge aus"));
        }
        SepaLastschriftMerger merger = new SepaLastschriftMerger();
        List<SepaLastschrift> lastschriften = Arrays.asList(source);
        List<SepaSammelLastschrift> result = merger.merge(lastschriften);
        int count = result.size();
        String text = count > 1 ? i18n.tr("{0} Sammelauftr\u00e4ge erzeugt", String.valueOf(count)) : i18n.tr("Sammelauftrag erzeugt");
        boolean bl = skip = merger.getSkipCount() > 0;
        if (skip) {
            text = String.valueOf(text) + i18n.tr("Auftr\u00e4ge mit Wiederholung wurden nicht gel\u00f6scht.");
        }
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, skip ? 2 : 0));
    }
}

