/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.SepaSammelTransferSplitDialog;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisungBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class SepaSammelUeberweisungSplit
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof SepaSammelUeberweisung) && !(context instanceof SepaSammelUeberweisung[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Sammelauftr\u00e4ge aus"));
        }
        SepaSammelUeberweisung[] source = null;
        source = context instanceof SepaSammelUeberweisung ? new SepaSammelUeberweisung[]{(SepaSammelUeberweisung)context} : (SepaSammelUeberweisung[])context;
        if (source.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Auftr\u00e4ge aus"));
        }
        AuslandsUeberweisung tx = null;
        ArrayList buchungen = new ArrayList();
        try {
            SepaSammelTransferSplitDialog dialog;
            Object o;
            HBCIDBService service = Settings.getDBService();
            boolean inDb = false;
            SepaSammelUeberweisung[] sepaSammelUeberweisungArray = source;
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                SepaSammelUeberweisung l = sepaSammelUeberweisungArray[n2];
                inDb |= !l.isNewObject();
                List b = l.getBuchungen();
                buchungen.addAll(b);
                ++n2;
            }
            boolean delete = false;
            if (inDb && (o = (dialog = new SepaSammelTransferSplitDialog(1, buchungen.size(), inDb)).open()) != null) {
                delete = (Boolean)o;
            }
            int count = 0;
            for (SepaSammelUeberweisungBuchung b : buchungen) {
                SepaSammelUeberweisung st = (SepaSammelUeberweisung)b.getSammelTransfer();
                AuslandsUeberweisung u = (AuslandsUeberweisung)service.createObject(AuslandsUeberweisung.class, null);
                if (tx == null) {
                    tx = u;
                    tx.transactionBegin();
                }
                u.setKonto(st.getKonto());
                u.setBetrag(b.getBetrag());
                u.setGegenkontoBLZ(b.getGegenkontoBLZ());
                u.setGegenkontoName(b.getGegenkontoName());
                u.setGegenkontoNummer(b.getGegenkontoNummer());
                u.setZweck(b.getZweck());
                u.setEndtoEndId(b.getEndtoEndId());
                u.setPurposeCode(b.getPurposeCode());
                u.setTermin(st.getTermin());
                u.store();
                Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)u));
                ++count;
            }
            if (delete) {
                SepaSammelUeberweisung[] sepaSammelUeberweisungArray2 = source;
                int n3 = source.length;
                int n4 = 0;
                while (n4 < n3) {
                    SepaSammelUeberweisung s = sepaSammelUeberweisungArray2[n4];
                    if (!s.isNewObject()) {
                        String id = s.getID();
                        s.delete();
                        Application.getMessagingFactory().sendMessage((Message)new ObjectDeletedMessage((GenericObject)s, id));
                    }
                    ++n4;
                }
            }
            if (tx != null) {
                tx.transactionCommit();
            }
            if (count > 1) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("{0} Einzelauftr\u00e4ge erzeugt", String.valueOf(count)), 0));
            } else {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Einzelauftrag erzeugt"), 0));
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.transactionRollback();
                }
                catch (Exception e2) {
                    Logger.error((String)"unable to rollback transaction", (Throwable)e);
                }
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"error while merging jobs", (Throwable)e);
            throw new ApplicationException(i18n.tr("Teilen der Sammel\u00fcberweisungen fehlgeschlagen: {0}", e.getMessage()));
        }
    }
}

