/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.SepaTransferMergeDialog;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisungBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;

public class SepaUeberweisungMerge
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof AuslandsUeberweisung) && !(context instanceof AuslandsUeberweisung[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Auftr\u00e4ge aus"));
        }
        AuslandsUeberweisung[] source = null;
        source = context instanceof AuslandsUeberweisung ? new AuslandsUeberweisung[]{(AuslandsUeberweisung)context} : (AuslandsUeberweisung[])context;
        if (source.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Auftr\u00e4ge aus"));
        }
        SepaSammelUeberweisung tx = null;
        try {
            String text;
            SepaTransferMergeDialog dialog;
            Object o;
            HBCIDBService service = Settings.getDBService();
            HashMap<String, SepaSammelUeberweisung> map = new HashMap<String, SepaSammelUeberweisung>();
            boolean inDb = false;
            boolean foundDate = false;
            AuslandsUeberweisung[] auslandsUeberweisungArray = source;
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                AuslandsUeberweisung l = auslandsUeberweisungArray[n2];
                inDb |= !l.isNewObject();
                String key = this.createKey(l);
                SepaSammelUeberweisung s = (SepaSammelUeberweisung)map.get(key);
                if (s == null) {
                    s = (SepaSammelUeberweisung)service.createObject(SepaSammelUeberweisung.class, null);
                    s.setKonto(l.getKonto());
                    s.setBezeichnung(i18n.tr("SEPA-Sammel\u00fcberweisung vom {0}", HBCI.LONGDATEFORMAT.format(new Date())));
                    map.put(key, s);
                }
                foundDate |= l.isTerminUeberweisung();
                ++n2;
            }
            boolean delete = false;
            int count = map.size();
            if ((count > 1 || inDb) && (o = (dialog = new SepaTransferMergeDialog(1, count, inDb)).open()) != null) {
                delete = (Boolean)o;
            }
            for (SepaSammelUeberweisung s : map.values()) {
                if (tx == null) {
                    tx = s;
                    tx.transactionBegin();
                }
                s.store();
                Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)s));
            }
            int skipCount = 0;
            AuslandsUeberweisung[] auslandsUeberweisungArray2 = source;
            int n3 = source.length;
            int n4 = 0;
            while (n4 < n3) {
                AuslandsUeberweisung l = auslandsUeberweisungArray2[n4];
                String key = this.createKey(l);
                SepaSammelUeberweisung s = (SepaSammelUeberweisung)map.get(key);
                if (s == null) {
                    Logger.error((String)("unable to find sepa transfer for key " + key));
                } else {
                    SepaSammelUeberweisungBuchung b = (SepaSammelUeberweisungBuchung)s.createBuchung();
                    b.setBetrag(l.getBetrag());
                    b.setEndtoEndId(l.getEndtoEndId());
                    b.setGegenkontoBLZ(l.getGegenkontoBLZ());
                    b.setGegenkontoName(l.getGegenkontoName());
                    b.setGegenkontoNummer(l.getGegenkontoNummer());
                    b.setZweck(l.getZweck());
                    b.store();
                    Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)b));
                    Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)s));
                    if (delete && !l.isNewObject()) {
                        if (MetaKey.REMINDER_UUID.get(l) != null) {
                            ++skipCount;
                        } else {
                            String id = l.getID();
                            l.delete();
                            Application.getMessagingFactory().sendMessage((Message)new ObjectDeletedMessage((GenericObject)l, id));
                        }
                    }
                }
                ++n4;
            }
            tx.transactionCommit();
            String string = text = count > 1 ? i18n.tr("{0} Sammelauftr\u00e4ge erzeugt", String.valueOf(count)) : i18n.tr("Sammelauftrag erzeugt");
            if (foundDate) {
                text = String.valueOf(text) + i18n.tr("Einer der Auftr\u00e4ge war bankseitig terminiert. Das Datum wurde ignoriert.");
            }
            if (skipCount > 0) {
                text = String.valueOf(text) + i18n.tr("Auftr\u00e4ge mit Wiederholung wurden nicht gel\u00f6scht.");
            }
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, foundDate || skipCount > 0 ? 2 : 0));
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.transactionRollback();
                }
                catch (Exception e2) {
                    Logger.error((String)"unable to rollback transaction", (Throwable)e);
                }
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"error while merging jobs", (Throwable)e);
            throw new ApplicationException(i18n.tr("Zusammenfassen der \u00dcberweisungen fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    private String createKey(AuslandsUeberweisung l) throws RemoteException {
        return l.getKonto().getID();
    }
}

