/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.ExportDialog;
import de.willuhn.jameica.hbci.gui.parts.SparQuote;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.List;

public class SparQuoteExport
implements Action {
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        if (context == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie mindestens einen Datensatz aus"));
        }
        Object[] u = null;
        try {
            if (context instanceof SparQuote.UmsatzEntry) {
                u = new SparQuote.UmsatzEntry[]{(SparQuote.UmsatzEntry)context};
            } else if (context instanceof Object[]) {
                Object[] objectArray = u = (Object[])context;
                int n = u.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (!(o instanceof SparQuote.UmsatzEntry)) {
                        u = null;
                        break;
                    }
                    ++n2;
                }
                u = (Object[])context;
            } else if (context instanceof List) {
                List l = (List)context;
                u = l.toArray(new SparQuote.UmsatzEntry[0]);
            }
            if (u == null || u.length == 0) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Datens\u00e4tze aus"));
            }
            ExportDialog d = new ExportDialog(u, SparQuote.UmsatzEntry.class);
            d.open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while exporting data", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Exportieren der Daten"));
        }
    }
}

