/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.SynchronizeExecuteDialog;
import de.willuhn.jameica.hbci.synchronize.Synchronization;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageBus;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Synchronize
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();
    private Iterator<Synchronization> list = null;

    public void handleAction(Object context) throws ApplicationException {
        Logger.info((String)"Start synchronization");
        if (!(context instanceof List)) {
            throw new ApplicationException(i18n.tr("Keine Synchronisierungsaufgaben ausgew\u00e4hlt"));
        }
        List list = (List)context;
        if (list.size() == 0) {
            throw new ApplicationException(i18n.tr("Keine Synchronisierungsaufgaben ausgew\u00e4hlt"));
        }
        Logger.info((String)("backends to synchronize: " + list.size()));
        ArrayList<Synchronization> result = new ArrayList<Synchronization>();
        ArrayList<SynchronizeJob> nonRecurring = new ArrayList<SynchronizeJob>();
        for (Object o : list) {
            if (!(o instanceof Synchronization)) {
                Logger.warn((String)("type " + o.getClass() + " is no valid synchronization"));
                continue;
            }
            Synchronization sync = (Synchronization)o;
            List<SynchronizeJob> jobs = sync.getJobs();
            for (SynchronizeJob job : jobs) {
                if (job.isRecurring()) continue;
                nonRecurring.add(job);
            }
            result.add(sync);
        }
        this.checkNonRecurring(nonRecurring);
        Logger.info((String)("synchronizing " + result.size() + " backends"));
        this.list = result.iterator();
        MessageBus.send((String)"hibiscus.syncengine.status", (Object)2);
        Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").registerMessageConsumer(this.mc);
        this.sync();
    }

    private void checkNonRecurring(List<SynchronizeJob> jobs) throws ApplicationException, OperationCanceledException {
        if (jobs == null || jobs.size() == 0) {
            return;
        }
        if (Application.inServerMode()) {
            return;
        }
        try {
            SynchronizeExecuteDialog d = new SynchronizeExecuteDialog(jobs, 1);
            d.open();
        }
        catch (OperationCanceledException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error((String)"error while checking jobs", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Ausf\u00fchren der Auftr\u00e4ge: {0}", e.getMessage()));
        }
    }

    private void sync() {
        if (!this.list.hasNext()) {
            Logger.info((String)"no more backends. synchronization done");
            this.finish(4);
            return;
        }
        try {
            Synchronization s = this.list.next();
            SynchronizeBackend backend = s.getBackend();
            List<SynchronizeJob> jobs = s.getJobs();
            Logger.info((String)("synchronizing backend " + backend.getName() + " with " + jobs.size() + " jobs"));
            backend.execute(jobs);
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").unRegisterMessageConsumer(this.mc);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            MessageBus.send((String)"hibiscus.syncengine.status", (Object)3);
        }
        catch (OperationCanceledException oce) {
            Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").unRegisterMessageConsumer(this.mc);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Synchronisierung abgebrochen"), 1));
            MessageBus.send((String)"hibiscus.syncengine.status", (Object)5);
        }
    }

    private void finish(int status) {
        MessageBus.send((String)"hibiscus.syncengine.status", (Object)status);
        Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            QueryMessage msg = (QueryMessage)message;
            Object data = msg.getData();
            if (!(data instanceof Integer)) {
                Logger.warn((String)("got unknown data: " + data));
                return;
            }
            int status = (Integer)data;
            if (status == 4) {
                Synchronize.this.sync();
            } else if (status == 3 || status == 5) {
                Synchronize.this.finish(status);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

