/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class TerminableMarkExecuted
implements Action {
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        if (context == null) {
            return;
        }
        Terminable[] t = null;
        t = context instanceof Terminable ? new Terminable[]{(Terminable)context} : (Terminable[])context;
        YesNoDialog d = new YesNoDialog(1);
        d.setTitle(i18n.tr("Sicher?"));
        if (t.length == 1) {
            d.setText(i18n.tr("Sind Sie sicher, dass Sie diesen Auftrag als \"ausgef\u00fchrt\" markieren wollen?\nDies kann nicht r\u00fcckg\u00e4ngig gemacht werden."));
        } else {
            d.setText(i18n.tr("Sind Sie sicher, dass Sie diese {0} Auftr\u00e4ge als \"ausgef\u00fchrt\" markieren wollen?\nDies kann nicht r\u00fcckg\u00e4ngig gemacht werden.", "" + t.length));
        }
        try {
            Boolean b = (Boolean)d.open();
            if (b == null || !b.booleanValue()) {
                return;
            }
            int i = 0;
            while (i < t.length) {
                Konto k;
                HibiscusDBObject tr;
                t[i].setAusgefuehrt(true);
                if (t[i] instanceof HibiscusTransfer) {
                    tr = (HibiscusTransfer)((Object)t[i]);
                    k = tr.getKonto();
                    if (k != null) {
                        k.addToProtokoll(i18n.tr("Auftrag \"{0}\" [Gegenkonto {1}, BLZ {2}] manuell als \"ausgef\u00fchrt\" markiert", new String[]{tr.getZweck(), tr.getGegenkontoName(), tr.getGegenkontoBLZ()}), 1);
                    }
                    Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)tr));
                } else if (t[i] instanceof SammelTransfer) {
                    tr = (SammelTransfer)t[i];
                    k = tr.getKonto();
                    if (k != null) {
                        k.addToProtokoll(i18n.tr("Sammel-Auftrag [Bezeichnung: {0}] manuell als \"ausgef\u00fchrt\" markiert", tr.getBezeichnung()), 1);
                    }
                    Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)tr));
                }
                ++i;
            }
            if (t.length == 1) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Auftrag als \"ausgef\u00fchrt\" markiert"), 0));
            } else {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Auftr\u00e4ge als \"ausgef\u00fchrt\" markiert"), 0));
            }
        }
        catch (OperationCanceledException oce) {
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unabel to mark transfers as executed", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Markieren als \"ausgef\u00fchrt\""), 1));
        }
    }
}

