/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.UmsatzTypListDialog;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class UmsatzAssign
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Ums\u00e4tze aus"));
        }
        if (!(context instanceof Umsatz) && !(context instanceof Umsatz[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Ums\u00e4tze aus"));
        }
        Umsatz[] umsaetze = null;
        umsaetze = context instanceof Umsatz ? new Umsatz[]{(Umsatz)context} : (Umsatz[])context;
        if (umsaetze.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Ums\u00e4tze aus"));
        }
        UmsatzTyp ut = null;
        try {
            int typ = 2;
            if (umsaetze.length == 1 && (ut = umsaetze[0].getUmsatzTyp()) == null && umsaetze[0].getBetrag() != 0.0) {
                typ = umsaetze[0].getBetrag() > 0.0 ? 1 : 0;
            }
            UmsatzTypListDialog d = new UmsatzTypListDialog(1, ut, typ);
            ut = (UmsatzTyp)d.open();
        }
        catch (OperationCanceledException oce) {
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while choosing umsatztyp", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausw\u00e4hlen der Umsatz-Kategorie"), 1));
        }
        try {
            umsaetze[0].transactionBegin();
            int i = 0;
            while (i < umsaetze.length) {
                umsaetze[i].setUmsatzTyp(ut);
                umsaetze[i].store();
                Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)umsaetze[i]));
                ++i;
            }
            umsaetze[0].transactionCommit();
            if (ut == null) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Zuordnung der Kategorie entfernt"), 0));
            } else {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Umsatz-Kategorie {0} zugeordnet", ut.getName()), 0));
            }
        }
        catch (ApplicationException ae) {
            this.rollback(umsaetze[0]);
            throw ae;
        }
        catch (Exception e) {
            this.rollback(umsaetze[0]);
            Logger.error((String)"error while assigning umsaetze", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Zuordnen der Umsatz-Kategorie"), 1));
        }
    }

    private void rollback(DBObject o) {
        if (o == null) {
            return;
        }
        try {
            Logger.info((String)"rollback transaction");
            o.transactionRollback();
        }
        catch (Exception e) {
            Logger.error((String)"unable to rollback transaction - useless", (Throwable)e);
        }
    }
}

