/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;

public class UmsatzDetailEdit
implements Action {
    private boolean createReverse = false;
    private Konto toBookTo = null;

    public UmsatzDetailEdit asReverse(Konto toBookTo) {
        this.createReverse = true;
        this.toBookTo = toBookTo;
        return this;
    }

    public void handleAction(Object context) throws ApplicationException {
        if (context instanceof Konto) {
            try {
                Konto k = (Konto)context;
                if (!k.hasFlag(2)) {
                    return;
                }
                Umsatz u = (Umsatz)Settings.getDBService().createObject(Umsatz.class, null);
                u.setKonto(k);
                Date d = new Date();
                u.setDatum(d);
                context = u;
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to create umsatz", (Throwable)re);
                I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                throw new ApplicationException(i18n.tr("Fehler beim Anlegen des Umsatzes: {0}", re.getMessage()));
            }
        }
        if (!(context instanceof Umsatz)) {
            return;
        }
        if (this.createReverse) {
            try {
                Umsatz orig = (Umsatz)context;
                Umsatz u = (Umsatz)orig.duplicate();
                u.setKonto(this.toBookTo);
                u.setBetrag(-orig.getBetrag());
                Konto konto = orig.getKonto();
                u.setGegenkontoBLZ(konto.getBLZ());
                u.setGegenkontoName(konto.getName());
                u.setGegenkontoNummer(konto.getKontonummer());
                u.setUmsatzTyp(null);
                context = u;
            }
            catch (RemoteException e) {
                throw new ApplicationException((Throwable)e);
            }
        }
        GUI.startView(de.willuhn.jameica.hbci.gui.views.UmsatzDetailEdit.class, (Object)context);
    }
}

