/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.ExportDialog;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class UmsatzExport
implements Action {
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        if (context == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie mindestens einen Umsatz aus"));
        }
        Object[] u = null;
        try {
            if (context instanceof Umsatz) {
                u = new Umsatz[]{(Umsatz)context};
            } else if (context instanceof Umsatz[]) {
                u = (Umsatz[])context;
            } else if (context instanceof UmsatzTreeNode) {
                UmsatzTreeNode node = (UmsatzTreeNode)context;
                ArrayList<Umsatz> result = new ArrayList<Umsatz>();
                this.collect(node, result);
                u = result.toArray(new Umsatz[0]);
            } else if (context instanceof UmsatzTreeNode[]) {
                ArrayList<Umsatz> result = new ArrayList<Umsatz>();
                UmsatzTreeNode[] umsatzTreeNodeArray = (UmsatzTreeNode[])context;
                int n = umsatzTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UmsatzTreeNode node = umsatzTreeNodeArray[n2];
                    this.collect(node, result);
                    ++n2;
                }
                u = result.toArray(new Umsatz[0]);
            }
            if (u == null || u.length == 0) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Ums\u00e4tze aus"));
            }
            ExportDialog d = new ExportDialog(u, Umsatz.class);
            d.open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while exporting umsaetze", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Exportieren der Ums\u00e4tze"));
        }
    }

    private void collect(UmsatzTreeNode node, List<Umsatz> target) {
        target.addAll(node.getUmsaetze());
        List<UmsatzTreeNode> children = node.getSubGroups();
        if (children == null || children.size() == 0) {
            return;
        }
        for (UmsatzTreeNode c : children) {
            this.collect(c, target);
        }
    }
}

