/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.boxes;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.KontoList;
import de.willuhn.jameica.hbci.gui.action.PassportDetail;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FirstStart
extends AbstractBox {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public boolean isActive() {
        return Settings.isFirstStart();
    }

    public boolean getDefaultEnabled() {
        return Settings.isFirstStart();
    }

    public int getDefaultIndex() {
        return 0;
    }

    public String getName() {
        return "Hibiscus: " + i18n.tr("Bank-Zugang einrichten");
    }

    public boolean isEnabled() {
        Manifest mf = Application.getPluginLoader().getManifest(HBCI.class);
        return mf.isInstalled() && Settings.isFirstStart();
    }

    public void paint(Composite parent) throws RemoteException {
        Color bg = null;
        int border = 0;
        int os = Application.getPlatform().getOS();
        if (os != 2 && os != 5 && os != 3) {
            bg = GUI.getDisplay().getSystemColor(1);
            border = 2048;
        }
        Composite comp = new Composite(parent, border);
        comp.setBackground(bg);
        comp.setBackgroundMode(2);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(34);
        gd.verticalSpan = 3;
        Label icon = new Label(comp, 0);
        icon.setBackground(bg);
        icon.setLayoutData((Object)gd);
        icon.setImage(SWTUtil.getImage((String)"hibiscus-large.png"));
        Label title = new Label(comp, 0);
        title.setBackground(bg);
        title.setLayoutData((Object)new GridData(768));
        title.setFont(Font.H2.getSWTFont());
        title.setText(i18n.tr("Sie starten Hibiscus zum ersten Mal."));
        Label desc = new Label(comp, 64);
        desc.setBackground(bg);
        desc.setLayoutData((Object)new GridData(768));
        desc.setText(i18n.tr("Bitte richten Sie zun\u00e4chst einen Bank-Zugang (Chipkarte, Schl\u00fcsseldatei oder PIN/TAN) ein.\n\nWechseln Sie anschlie\u00dfend zur Konten-\u00dcbersicht und pr\u00fcfen Sie die angelegten Konten. Falls sie nicht automatisch angelegt wurden, dann erstellen Sie das Konto bitte manuell."));
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Bank-Zugang einrichten"), (Action)new PassportDetail(), null, true, "system-users.png");
        buttons.addButton(i18n.tr("Konten-\u00dcbersicht"), (Action)new KontoList(), null, false, "wallet-open.png");
        buttons.paint(comp);
    }

    public int getHeight() {
        return 180;
    }
}

