/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.boxes;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.NachrichtOpen;
import de.willuhn.jameica.hbci.gui.parts.NachrichtList;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Nachricht;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class NachrichtBox
extends AbstractBox
implements Box {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private NachrichtList list = null;
    private MessageConsumer mc = new MyMessageConsumer();

    public boolean getDefaultEnabled() {
        return true;
    }

    public int getDefaultIndex() {
        return 0;
    }

    public String getName() {
        return "Hibiscus: " + i18n.tr("System-Nachrichten der Bank");
    }

    public void paint(Composite parent) throws RemoteException {
        DBIterator iterator = Settings.getDBService().createList(Nachricht.class);
        iterator.setOrder("order by datum desc");
        iterator.addFilter("gelesen is null or gelesen = 0");
        this.list = new NachrichtList((GenericIterator)iterator, new NachrichtOpen());
        this.list.setSummary(false);
        this.list.paint(parent);
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NachrichtBox.this.list = null;
                Application.getMessagingFactory().unRegisterMessageConsumer(NachrichtBox.this.mc);
            }
        });
    }

    public boolean isActive() {
        return super.isActive() && this.isEnabled();
    }

    public boolean isEnabled() {
        try {
            DBIterator iterator = Settings.getDBService().createList(Nachricht.class);
            iterator.addFilter("gelesen is null or gelesen = 0");
            return iterator.hasNext();
        }
        catch (Exception e) {
            Logger.error((String)"unable to check for new messages", (Throwable)e);
            return super.isEnabled();
        }
    }

    public int getHeight() {
        return 120;
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public boolean autoRegister() {
            return false;
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            ImportMessage im = (ImportMessage)message;
            GenericObject o = im.getObject();
            if (!(o instanceof Nachricht)) {
                return;
            }
            final Nachricht n = (Nachricht)o;
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((MyMessageConsumer)MyMessageConsumer.this).NachrichtBox.this.list == null) {
                        return;
                    }
                    try {
                        ((MyMessageConsumer)MyMessageConsumer.this).NachrichtBox.this.list.addItem(n);
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add message", (Throwable)e);
                    }
                }
            });
        }
    }
}

