/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.boxes;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Overview
extends AbstractBox
implements Box {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static Object konto = null;
    private static Date startDate = null;
    private static Date endDate = null;
    private KontoInput kontoAuswahl = null;
    private Input saldo = null;
    private Input ausgaben = null;
    private Input einnahmen = null;
    private Input bilanz = null;
    private DateInput start = null;
    private DateInput end = null;
    private MessageConsumer mc = new SaldoMessageConsumer();

    public String getName() {
        return "Hibiscus: " + i18n.tr("Finanz-\u00dcbersicht");
    }

    public void paint(Composite parent) throws RemoteException {
        SimpleContainer group = new SimpleContainer(parent);
        group.addLabelPair(String.valueOf(i18n.tr("Konto")) + ":", this.getKontoAuswahl());
        group.addLabelPair(String.valueOf(i18n.tr("Beginn des Zeitraumes")) + ":", this.getStart());
        group.addLabelPair(String.valueOf(i18n.tr("Ende des Zeitraumes")) + ":", this.getEnd());
        group.addLabelPair(String.valueOf(i18n.tr("Saldo")) + ":", this.getSaldo());
        group.addLabelPair(String.valueOf(i18n.tr("Einnahmen im Zeitraum")) + ":", this.getEinnahmen());
        group.addLabelPair(String.valueOf(i18n.tr("Ausgaben im Zeitraum")) + ":", this.getAusgaben());
        group.addSeparator();
        group.addLabelPair(String.valueOf(i18n.tr("Bilanz")) + ":", this.getBilanz());
        this.refresh();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(Overview.this.mc);
            }
        });
    }

    public int getDefaultIndex() {
        return 0;
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    private Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(konto != null && konto instanceof Konto && ((Konto)konto).getID() != null ? (Konto)konto : null, KontoFilter.ACTIVE);
        this.kontoAuswahl.setSupportGroups(true);
        this.kontoAuswahl.setPleaseChoose(i18n.tr("Alle Konten"));
        this.kontoAuswahl.addListener(new Listener(){

            public void handleEvent(Event event) {
                Overview.this.refresh();
            }
        });
        return this.kontoAuswahl;
    }

    private Input getSaldo() {
        if (this.saldo != null) {
            return this.saldo;
        }
        this.saldo = new LabelInput("");
        this.saldo.setComment("");
        return this.saldo;
    }

    private Input getStart() {
        if (this.start != null) {
            return this.start;
        }
        if (startDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(5, 1);
            startDate = cal.getTime();
        }
        this.start = new DateInput(DateUtil.startOfDay((Date)startDate), HBCI.DATEFORMAT);
        this.start.addListener(new Listener(){

            public void handleEvent(Event event) {
                Overview.this.refresh();
            }
        });
        return this.start;
    }

    private Input getEnd() {
        if (this.end != null) {
            return this.end;
        }
        if (endDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(5, cal.getActualMaximum(5));
            endDate = cal.getTime();
        }
        this.end = new DateInput(DateUtil.endOfDay((Date)endDate), HBCI.DATEFORMAT);
        this.end.addListener(new Listener(){

            public void handleEvent(Event event) {
                Overview.this.refresh();
            }
        });
        return this.end;
    }

    private synchronized void refresh() {
        try {
            konto = this.getKontoAuswahl().getValue();
            startDate = (Date)this.getStart().getValue();
            endDate = (Date)this.getEnd().getValue();
            Date saldoDate = null;
            double d = 0.0;
            if (konto == null || !(konto instanceof Konto)) {
                DBIterator konten = Settings.getDBService().createList(Konto.class);
                if (konto != null && konto instanceof String) {
                    konten.addFilter("kategorie = ?", new Object[]{(String)konto});
                }
                while (konten.hasNext()) {
                    Konto k = (Konto)konten.next();
                    d += k.getSaldo();
                }
            } else {
                d = ((Konto)konto).getSaldo();
                saldoDate = ((Konto)konto).getSaldoDatum();
            }
            LabelInput saldo = (LabelInput)this.getSaldo();
            saldo.setValue((Object)HBCI.DECIMALFORMAT.format(d));
            String comment = HBCIProperties.CURRENCY_DEFAULT_DE;
            if (saldoDate != null) {
                comment = String.valueOf(comment) + " [" + HBCI.DATEFORMAT.format(saldoDate) + "]";
            }
            saldo.setComment(comment);
            saldo.setColor(ColorUtil.getColor(d, Color.ERROR, Color.SUCCESS, Color.FOREGROUND));
            if (startDate == null || endDate == null || startDate.after(endDate)) {
                return;
            }
            double in = 0.0;
            double out = 0.0;
            if (konto == null || !(konto instanceof Konto)) {
                DBIterator i = Settings.getDBService().createList(Konto.class);
                if (konto != null && konto instanceof String) {
                    i.addFilter("kategorie = ?", new Object[]{(String)konto});
                }
                while (i.hasNext()) {
                    Konto k = (Konto)i.next();
                    in += KontoUtil.getEinnahmen(k, startDate, endDate, false);
                    out += KontoUtil.getAusgaben(k, startDate, endDate, false);
                }
            } else {
                in = KontoUtil.getEinnahmen((Konto)konto, startDate, endDate, false);
                out = KontoUtil.getAusgaben((Konto)konto, startDate, endDate, false);
            }
            out = Math.abs(out);
            this.getAusgaben().setValue((Object)HBCI.DECIMALFORMAT.format(out));
            this.getEinnahmen().setValue((Object)HBCI.DECIMALFORMAT.format(in));
            double diff = in - out;
            this.getBilanz().setValue((Object)HBCI.DECIMALFORMAT.format(diff));
            ((LabelInput)this.getBilanz()).setColor(ColorUtil.getColor(diff, Color.ERROR, Color.SUCCESS, Color.FOREGROUND));
        }
        catch (RemoteException e) {
            Logger.error((String)"unable to calculate sum", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Berechnen der Bilanz"), 1));
        }
    }

    private Input getBilanz() {
        if (this.bilanz != null) {
            return this.bilanz;
        }
        this.bilanz = new LabelInput("");
        this.bilanz.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        return this.bilanz;
    }

    private Input getAusgaben() {
        if (this.ausgaben != null) {
            return this.ausgaben;
        }
        this.ausgaben = new LabelInput("");
        this.ausgaben.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        ((LabelInput)this.ausgaben).setColor(Color.ERROR);
        return this.ausgaben;
    }

    private Input getEinnahmen() {
        if (this.einnahmen != null) {
            return this.einnahmen;
        }
        this.einnahmen = new LabelInput("");
        this.einnahmen.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        ((LabelInput)this.einnahmen).setColor(Color.SUCCESS);
        return this.einnahmen;
    }

    public boolean isActive() {
        return super.isActive() && !Settings.isFirstStart();
    }

    private class SaldoMessageConsumer
    implements MessageConsumer {
        private SaldoMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{SaldoMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Overview.this.refresh();
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

