/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.boxes;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.CopyClipboard;
import de.willuhn.jameica.hbci.gui.action.PassportDetail;
import de.willuhn.jameica.hbci.passports.pintan.PinTanMigrationService;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import javax.annotation.Resource;
import org.eclipse.swt.widgets.Composite;

public class PinTanMigration
extends AbstractBox
implements Box {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    @Resource
    private PinTanMigrationService pinTanMigrationService;

    public boolean getDefaultEnabled() {
        return true;
    }

    public int getDefaultIndex() {
        return 0;
    }

    public String getName() {
        return "Hibiscus: " + i18n.tr("Aktualisierung von PIN/TAN-Bankzug\u00e4ngen");
    }

    public void paint(Composite parent) throws RemoteException {
        List<PinTanMigrationService.VerificationEntry> list = this.pinTanMigrationService.getConfigs();
        if (list.isEmpty()) {
            return;
        }
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Bei den folgenden Bankzug\u00e4ngen ist die Aktualisierung der URL erforderlich."), true, Color.ERROR);
        c.addText(i18n.tr("W\u00e4hlen Sie die Bankzug\u00e4nge aus, deren URL aktualisiert werden soll und klicken Sie anschlie\u00dfend auf die Schaltfl\u00e4che \"Ausgew\u00e4hlte Bankzug\u00e4nge aktualisieren\". Sie k\u00f6nnen die URL alternativ auch selbst in der Detailansicht des Bankzugangs \u00e4ndern."), true);
        final TablePart table = new TablePart(list, new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null) {
                    return;
                }
                PinTanMigrationService.VerificationEntry l = (PinTanMigrationService.VerificationEntry)context;
                new PassportDetail().handleAction(l.getConfig());
            }
        });
        table.setCheckable(true);
        table.setRememberColWidths(true);
        table.setRememberOrder(true);
        table.removeFeature(FeatureSummary.class);
        table.addColumn(i18n.tr("Bezeichnung"), "config.description");
        table.addColumn(i18n.tr("Bisherige URL"), "oldUrl");
        table.addColumn(i18n.tr("Neue URL"), "newUrl");
        ContextMenu ctx = new ContextMenu();
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("\u00d6ffnen"), a -> new PassportDetail().handleAction(((PinTanMigrationService.VerificationEntry)a).getConfig()), "document-open.png"));
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Bisherige URL kopieren"), a -> new CopyClipboard().handleAction(((PinTanMigrationService.VerificationEntry)a).getOldUrl()), "edit-copy.png"));
        ctx.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Neue URL kopieren"), a -> new CopyClipboard().handleAction(((PinTanMigrationService.VerificationEntry)a).getNewUrl()), "edit-copy.png"));
        table.setContextMenu(ctx);
        Button apply = new Button(i18n.tr("Ausgew\u00e4hlte Bankzug\u00e4nge aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    if (!Application.getCallback().askUser(i18n.tr("Sicher? Sie k\u00f6nnen die URL im Bankzugang jederzeit wieder \u00e4ndern."))) {
                        return;
                    }
                    List list = table.getItems(true);
                    if (list == null || list.isEmpty()) {
                        return;
                    }
                    int count = PinTanMigration.this.pinTanMigrationService.migrate(list);
                    table.removeAll();
                    for (PinTanMigrationService.VerificationEntry v : PinTanMigration.this.pinTanMigrationService.getConfigs()) {
                        table.addItem((Object)v);
                    }
                    int type = count > 0 ? 0 : 2;
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(Application.getI18n().tr("Bankzug\u00e4nge erfolgreich aktualisiert: {0}", Integer.toString(count)), type));
                }
                catch (Exception ex) {
                    Logger.error((String)"unable to migrate passports", (Throwable)ex);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(Application.getI18n().tr("Aktualisieren fehlgeschlagen: {0}", ex.getMessage()), 1));
                }
            }
        }, null, false, "emblem-symbolic-link.png");
        table.addSelectionListener(e -> {
            try {
                List selected = table.getItems(true);
                apply.setEnabled(selected != null && selected.size() > 0);
            }
            catch (Exception ex) {
                Logger.error((String)"unable to update button", (Throwable)ex);
            }
        });
        table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(apply);
        buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                PinTanMigration.this.pinTanMigrationService.refresh();
                GUI.getCurrentView().reload();
            }
        }, null, false, "view-refresh.png");
        buttons.paint(parent);
    }

    public boolean isActive() {
        return super.isActive() && this.isEnabled();
    }

    public boolean isEnabled() {
        return super.isEnabled() && !this.pinTanMigrationService.getConfigs().isEmpty();
    }

    public int getHeight() {
        return 180;
    }
}

