/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.boxes;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.forecast.ForecastCreator;
import de.willuhn.jameica.hbci.forecast.SaldoLimit;
import de.willuhn.jameica.hbci.gui.action.KontoLimitsConfigure;
import de.willuhn.jameica.hbci.gui.action.KontoNew;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class SaldoLimits
extends AbstractBox
implements Box {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public boolean getDefaultEnabled() {
        return true;
    }

    public int getDefaultIndex() {
        return 0;
    }

    public String getName() {
        return "Hibiscus: " + i18n.tr("Saldo-Limits der Konten");
    }

    public void paint(Composite parent) throws RemoteException {
        List<SaldoLimit> limits = ForecastCreator.getLimits();
        if (limits.isEmpty()) {
            return;
        }
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(i18n.tr("Bei den folgenden Konten werden die Salden voraussichtlich die angegebenen Limits erreichen."), true, Color.ERROR);
        TablePart table = new TablePart(limits, new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null) {
                    return;
                }
                SaldoLimit l = (SaldoLimit)context;
                new KontoNew().handleAction(l.getKonto());
            }
        });
        table.setRememberColWidths(true);
        table.setRememberOrder(true);
        table.removeFeature(FeatureSummary.class);
        table.addColumn(i18n.tr("Konto"), "konto", k -> KontoUtil.toString((Konto)k));
        table.addColumn(i18n.tr("Art des Limits"), "type", t -> ((SaldoLimit.Type)((Object)((Object)t))).getDescription());
        table.addColumn(i18n.tr("Limit"), "value", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        table.addColumn(i18n.tr("Voraussichtlich erreicht am"), "date", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        final AtomicInteger notify = new AtomicInteger();
        table.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                SaldoLimit limit = (SaldoLimit)item.getData();
                if (limit.isNotify()) {
                    item.setFont(Font.BOLD.getSWTFont());
                    notify.incrementAndGet();
                }
            }
        });
        table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                ForecastCreator.updateLimits();
                GUI.getCurrentView().reload();
            }
        }, null, false, "view-refresh.png");
        buttons.addButton(String.valueOf(i18n.tr("Limits konfigurieren")) + "...", new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new KontoLimitsConfigure().handleAction(context);
                ForecastCreator.updateLimits();
                GUI.getCurrentView().reload();
            }
        }, null, false, "office-chart-area.png");
        buttons.paint(parent);
        GUI.getNavigation().setUnreadCount("jameica.start", notify.get());
    }

    public boolean isActive() {
        return super.isActive() && this.isEnabled();
    }

    public boolean isEnabled() {
        return !ForecastCreator.getLimits().isEmpty();
    }

    public int getHeight() {
        return 220;
    }
}

