/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.Chart;
import de.willuhn.jameica.hbci.gui.chart.ChartData;
import de.willuhn.jameica.hbci.gui.chart.ChartFeature;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.internal.Legend;

public abstract class AbstractChart<T extends ChartData>
implements Chart<T> {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String title = null;
    private Map<RGB, Color> colors = new HashMap<RGB, Color>();
    private List<T> data = new ArrayList<T>();
    private org.eclipse.swtchart.Chart chart = null;
    private List<ChartFeature> features = new ArrayList<ChartFeature>();

    @Override
    public void setTitle(String title) {
        this.title = title;
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.getTitle().setText(this.title);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public org.eclipse.swtchart.Chart getChart() {
        return this.chart;
    }

    protected void setChart(final org.eclipse.swtchart.Chart chart) {
        this.chart = chart;
        if (this.chart == null) {
            return;
        }
        final Legend l = (Legend)chart.getLegend();
        l.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ISeries s = AbstractChart.this.getSeries(chart, l, e.x, e.y);
                if (s != null) {
                    s.setVisible(!s.isVisible());
                    chart.redraw();
                }
            }
        });
        l.setMenu(this.createLegendContextMenu(chart, l));
    }

    private Menu createLegendContextMenu(org.eclipse.swtchart.Chart chart, Legend l) {
        Menu m = new Menu((Decorations)l.getParent().getShell(), 8);
        this.addShowMenuItem(m, i18n.tr("alle anzeigen"), true);
        this.addShowMenuItem(m, i18n.tr("alle ausblenden"), false);
        return m;
    }

    private void addShowMenuItem(Menu m, String text, final boolean setVisibleValue) {
        MenuItem item = new MenuItem(m, 8);
        item.setText(text);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISeriesSet seriesSet = AbstractChart.this.chart.getSeriesSet();
                ISeries[] iSeriesArray = seriesSet.getSeries();
                int n = iSeriesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries s = iSeriesArray[n2];
                    s.setVisible(setVisibleValue);
                    ++n2;
                }
                AbstractChart.this.chart.redraw();
            }
        });
    }

    private ISeries getSeries(org.eclipse.swtchart.Chart chart, Legend l, int x, int y) {
        ISeriesSet seriesSet = chart.getSeriesSet();
        ISeries[] iSeriesArray = seriesSet.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            Rectangle sbounds = l.getBounds(s.getId());
            if (sbounds.contains(x, y)) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void addData(T data) {
        if (data != null) {
            this.data.add(data);
        }
    }

    @Override
    public void removeData(T data) {
        if (data != null) {
            this.data.remove(data);
        }
    }

    @Override
    public void removeAllData() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    List<T> getData() {
        return this.data;
    }

    Color getColor(RGB rgb) {
        Color c = this.colors.get(rgb);
        if (c != null && !c.isDisposed()) {
            return c;
        }
        c = new Color((Device)GUI.getDisplay(), rgb);
        this.colors.put(rgb, c);
        return c;
    }

    private void cleanMenu() {
        try {
            MenuItem[] items = this.chart.getPlotArea().getControl().getMenu().getItems();
            if (items == null || items.length == 0) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                MenuItem mi = items[i];
                String text = mi.getText();
                if (text != null && text.equals("PROPERTIES")) {
                    mi.dispose();
                    if (i > 0) {
                        items[i - 1].dispose();
                    }
                    return;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    for (Color c : AbstractChart.this.colors.values()) {
                        if (c == null || c.isDisposed()) continue;
                        c.dispose();
                    }
                }
                finally {
                    AbstractChart.this.colors.clear();
                }
            }
        });
        this.cleanMenu();
        this.featureEvent(ChartFeature.Event.PAINT);
    }

    @Override
    public void addFeature(ChartFeature feature) {
        this.features.add(feature);
    }

    @Override
    public void removeFeature(ChartFeature feature) {
        this.features.remove(feature);
    }

    private void featureEvent(ChartFeature.Event e) {
        if (this.features.size() == 0) {
            return;
        }
        ChartFeature.Context ctx = new ChartFeature.Context();
        ctx.chart = this;
        ctx.event = e;
        for (ChartFeature f : this.features) {
            if (!f.onEvent(e)) continue;
            try {
                f.handleEvent(e, ctx);
            }
            catch (Exception ex) {
                Logger.error((String)("error while handling event " + (Object)((Object)e)), (Throwable)ex);
            }
        }
    }
}

