/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.AbstractChart;
import de.willuhn.jameica.hbci.gui.chart.ChartData;
import de.willuhn.logging.Logger;
import de.willuhn.util.ColorGenerator;
import java.rmi.RemoteException;
import java.text.Format;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.IGrid;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesLabel;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;

public class BarChart
extends AbstractChart {
    private Composite comp = null;

    @Override
    public void redraw() throws RemoteException {
        if (this.comp == null || this.comp.isDisposed()) {
            return;
        }
        SWTUtil.disposeChildren((Composite)this.comp);
        this.comp.setLayout((Layout)SWTUtil.createGrid((int)1, (boolean)false));
        this.setChart((Chart)new InteractiveChart(this.comp, 2048));
        this.getChart().setLayoutData((Object)new GridData(1808));
        this.getChart().getLegend().setVisible(false);
        this.getChart().setOrientation(512);
        this.getChart().setBackground(GUI.getDisplay().getSystemColor(1));
        this.getChart().setBackgroundInPlotArea(GUI.getDisplay().getSystemColor(1));
        ITitle title = this.getChart().getTitle();
        title.setText(this.getTitle());
        title.setForeground(GUI.getDisplay().getSystemColor(2));
        title.setFont(Font.BOLD.getSWTFont());
        Color gray = this.getColor(new RGB(230, 230, 230));
        IAxis axis = this.getChart().getAxisSet().getXAxis(0);
        axis.getTitle().setForeground(GUI.getDisplay().getSystemColor(1));
        IGrid grid = axis.getGrid();
        grid.setStyle(LineStyle.DOT);
        grid.setForeground(gray);
        axis.getTick().setForeground(GUI.getDisplay().getSystemColor(2));
        axis = this.getChart().getAxisSet().getYAxis(0);
        axis.getTitle().setVisible(false);
        grid = axis.getGrid();
        grid.setStyle(LineStyle.DOT);
        grid.setForeground(gray);
        IAxisTick tick = axis.getTick();
        tick.setFormat((Format)HBCI.DECIMALFORMAT);
        tick.setForeground(GUI.getDisplay().getSystemColor(2));
        List data = this.getData();
        int i = 0;
        while (i < data.size()) {
            LinkedList<String> labelLine = new LinkedList<String>();
            LinkedList<Number> dataLine = new LinkedList<Number>();
            ChartData cd = (ChartData)data.get(i);
            List list = cd.getData();
            String dataAttribute = cd.getDataAttribute();
            String labelAttribute = cd.getLabelAttribute();
            if (list == null || list.size() == 0 || dataAttribute == null || labelAttribute == null) {
                Logger.debug((String)"skipping data line, contains no data");
                dataLine.add(0.0);
                labelLine.add("");
            } else {
                for (Object o : list) {
                    Number n;
                    Object value = BeanUtil.get(o, (String)dataAttribute);
                    Object label = BeanUtil.get(o, (String)labelAttribute);
                    if (label == null || value == null || !(value instanceof Number) || Math.abs((n = (Number)value).doubleValue()) < 0.01) continue;
                    dataLine.add(n);
                    labelLine.add(label.toString());
                }
            }
            if (dataLine.size() != 0) {
                IAxis axis2 = this.getChart().getAxisSet().getXAxis(0);
                axis2.setCategorySeries(labelLine.toArray(new String[0]));
                axis2.enableCategory(true);
                IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, Integer.toString(i));
                barSeries.setYSeries(this.toArray(dataLine));
                int[] cValues = ColorGenerator.create((int)(0 + i));
                Color color = this.getColor(new RGB(cValues[0], cValues[1], cValues[2]));
                barSeries.setBarColor(color);
                ISeriesLabel label = barSeries.getLabel();
                label.setFont(Font.SMALL.getSWTFont());
                label.setFormat(HBCI.DECIMALFORMAT.toPattern());
                label.setForeground(GUI.getDisplay().getSystemColor(2));
                label.setVisible(true);
            }
            ++i;
        }
        ITitle title2 = this.getChart().getTitle();
        title2.setText(this.getTitle());
        this.comp.layout();
        this.getChart().getAxisSet().adjustRange();
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        if (this.comp != null) {
            return;
        }
        this.comp = new Composite(parent, 0);
        this.comp.setLayoutData((Object)new GridData(1808));
        this.redraw();
        super.paint(parent);
    }

    private double[] toArray(List<Number> list) {
        double[] values = new double[list.size()];
        int i = 0;
        while (i < list.size()) {
            values[i] = list.get(i).doubleValue();
            ++i;
        }
        return values;
    }
}

