/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.jameica.hbci.forecast.ForecastCreator;
import de.willuhn.jameica.hbci.gui.chart.AbstractChartDataSaldo;
import de.willuhn.jameica.hbci.gui.chart.LineStyle;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Value;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public class ChartDataSaldoForecast
extends AbstractChartDataSaldo {
    private Konto konto = null;
    private Date end = null;
    private List<Value> data = null;

    public ChartDataSaldoForecast(Konto k, Date end) {
        this.konto = k;
        this.end = end;
    }

    @Override
    public List getData() throws RemoteException {
        if (this.data != null) {
            return this.data;
        }
        this.data = ForecastCreator.create(this.konto, this.end);
        return this.data;
    }

    @Override
    public LineStyle getLineStyle() throws RemoteException {
        return LineStyle.DOT;
    }

    @Override
    public boolean isFilled() throws RemoteException {
        return true;
    }

    @Override
    public boolean isLegendEnabled() throws RemoteException {
        return false;
    }

    @Override
    public String getLabel() throws RemoteException {
        String s = this.konto != null ? this.konto.getBezeichnung() : i18n.tr("Alle Konten");
        return String.valueOf(s) + ": " + i18n.tr("Prognose");
    }
}

