/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.jameica.hbci.forecast.ForecastCreator;
import de.willuhn.jameica.hbci.forecast.SaldoLimit;
import de.willuhn.jameica.hbci.gui.chart.AbstractChartDataSaldo;
import de.willuhn.jameica.hbci.gui.chart.LineStyle;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.util.ColorGenerator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ChartDataSaldoLimit
extends AbstractChartDataSaldo {
    private SaldoLimit.Type type = null;
    private List<Value> data = new ArrayList<Value>();

    public ChartDataSaldoLimit(Konto k, Date start, SaldoLimit.Type type) {
        this.type = type;
        SaldoLimit l = ForecastCreator.getLimit(k, type);
        if (l != null && l.isEnabled()) {
            if (start != null) {
                this.data.add(new Value(start, l.getValue()));
            }
            Calendar cal = Calendar.getInstance();
            cal.add(5, l.getDays());
            this.data.add(new Value(cal.getTime(), l.getValue()));
        }
    }

    @Override
    public List getData() throws RemoteException {
        return this.data;
    }

    @Override
    public String getLabel() throws RemoteException {
        return this.type.getDescription();
    }

    @Override
    public int[] getColor() throws RemoteException {
        return ColorGenerator.create((int)(8 + (this.type == SaldoLimit.Type.UPPER ? 3 : 0)));
    }

    @Override
    public LineStyle getLineStyle() throws RemoteException {
        return LineStyle.DASH;
    }

    @Override
    public int getLineWidth() throws RemoteException {
        return 2;
    }

    @Override
    public boolean isLegendEnabled() throws RemoteException {
        return !this.data.isEmpty();
    }

    @Override
    public boolean isFilled() throws RemoteException {
        return false;
    }
}

