/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.jameica.hbci.gui.chart.AbstractChartDataSaldo;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChartDataSaldoTrend
extends AbstractChartDataSaldo {
    private List<Value> data = null;
    private String label = null;

    public void add(List<Value> data) {
        if (data == null) {
            Logger.warn((String)"skipping data line, contains no data");
            return;
        }
        if (this.data == null) {
            this.data = new ArrayList<Value>();
            int i = 0;
            while (i < data.size()) {
                this.data.add(this.createAverage(data, i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < data.size()) {
                Value s = this.data.get(i);
                s.setValue(s.getValue() + this.createAverage(data, i).getValue());
                ++i;
            }
        }
    }

    @Override
    public List getData() throws RemoteException {
        return this.data;
    }

    @Override
    public String getLabel() throws RemoteException {
        return this.label != null ? this.label : i18n.tr("Monatsdurchschnitt");
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean getCurve() {
        return true;
    }

    private Value createAverage(List<Value> list, int pos) {
        Value item = new Value(list.get(pos).getDate(), 0.0);
        int found = 0;
        Date first = null;
        int i = -30;
        while (i <= 0) {
            try {
                Value current = list.get(pos + i);
                ++found;
                if (first == null) {
                    first = current.getDate();
                }
                item.setValue(item.getValue() + current.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        item.setValue(item.getValue() / (double)found);
        return item;
    }

    @Override
    public boolean isFilled() throws RemoteException {
        return false;
    }
}

