/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.chart.ChartData;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ChartDataUmsatzTyp
implements ChartData {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private int type = 2;
    private int days = -1;

    public ChartDataUmsatzTyp(int typ) {
        this(typ, -1);
    }

    public ChartDataUmsatzTyp(int typ, int days) {
        this.type = typ;
        this.days = days;
    }

    @Override
    public List getData() throws RemoteException {
        DBIterator list = Settings.getDBService().createList(UmsatzTyp.class);
        if (this.type != 2) {
            list.addFilter("umsatztyp = " + this.type);
        }
        ArrayList<Entry> result = new ArrayList<Entry>();
        while (list.hasNext()) {
            result.add(new Entry((UmsatzTyp)list.next()));
        }
        return result;
    }

    @Override
    public String getLabel() throws RemoteException {
        return i18n.tr("Umsatz-Verteilung");
    }

    @Override
    public String getDataAttribute() throws RemoteException {
        return "umsatz";
    }

    @Override
    public String getLabelAttribute() throws RemoteException {
        return "name";
    }

    public class Entry {
        private UmsatzTyp ut = null;

        private Entry(UmsatzTyp ut) {
            this.ut = ut;
        }

        public Double getUmsatz() throws RemoteException {
            return Math.abs(this.ut.getUmsatz(ChartDataUmsatzTyp.this.days));
        }

        public String getName() throws RemoteException {
            return this.ut.getName();
        }
    }
}

