/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.ChartFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;

public class ChartFeatureTooltip
implements ChartFeature {
    private int highlightX;
    private int highlightY;
    private int seriesIndex;
    private String tooltip;

    @Override
    public boolean onEvent(ChartFeature.Event e) {
        return e == ChartFeature.Event.PAINT;
    }

    @Override
    public void handleEvent(ChartFeature.Event e, ChartFeature.Context ctx) {
        final Chart c = ctx.chart.getChart();
        final Control control = c.getPlotArea().getControl();
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                IAxis yAxis;
                IAxis xAxis = c.getAxisSet().getXAxis(0);
                Collection<SeriesData> foundSeries = ChartFeatureTooltip.this.findClosestSeries(c, event, xAxis, yAxis = c.getAxisSet().getYAxis(0));
                if (foundSeries.isEmpty()) {
                    return;
                }
                ChartFeatureTooltip.this.tooltip = ChartFeatureTooltip.this.getTooltipText(foundSeries);
                SeriesData data = foundSeries.iterator().next();
                ChartFeatureTooltip.this.highlightX = xAxis.getPixelCoordinate(data.closestX);
                ChartFeatureTooltip.this.highlightY = yAxis.getPixelCoordinate(data.closestY);
                ChartFeatureTooltip.this.seriesIndex = data.seriesIndex;
                control.redraw();
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ChartFeatureTooltip.this.tooltip != null) {
                    ChartFeatureTooltip.this.tooltip = null;
                    c.getPlotArea().setToolTipText(null);
                    control.redraw();
                }
            }
        });
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ChartFeatureTooltip.this.tooltip != null) {
                    ISeries[] series = c.getSeriesSet().getSeries();
                    c.getPlotArea().setToolTipText(ChartFeatureTooltip.this.tooltip);
                    ChartFeatureTooltip.this.paintChartPoint(event.gc, ChartFeatureTooltip.this.highlightX, ChartFeatureTooltip.this.highlightY, series[ChartFeatureTooltip.this.seriesIndex]);
                    c.layout(true);
                }
            }
        });
    }

    protected String getTooltipText(Collection<SeriesData> foundData) {
        SeriesData data2;
        StringBuilder text = new StringBuilder();
        for (SeriesData data2 : foundData) {
            text.append(this.formatSeriesLabel(data2));
            text.append("\n");
        }
        data2 = foundData.iterator().next();
        text.append(this.formatSeriesValue(data2));
        return text.toString();
    }

    protected String formatSeriesLabel(SeriesData data) {
        return data.closestSerie.getId();
    }

    protected String formatSeriesValue(SeriesData data) {
        StringBuilder sb = new StringBuilder();
        sb.append(HBCI.DATEFORMAT.format(new Date((long)data.closestX)));
        sb.append(": ");
        sb.append(HBCI.DECIMALFORMAT.format(data.closestY));
        return sb.toString();
    }

    protected void paintChartPoint(GC gc, int highlightX, int highlightY, ISeries series) {
        Color color = Display.getDefault().getSystemColor(9);
        if (series instanceof ILineSeries) {
            color = ((ILineSeries)series).getLineColor();
        }
        gc.setBackground(color);
        gc.setAlpha(128);
        gc.fillOval(highlightX - 5, highlightY - 5, 10, 10);
    }

    protected Collection<SeriesData> findClosestSeries(Chart chart, MouseEvent event, IAxis xAxis, IAxis yAxis) {
        double x = xAxis.getDataCoordinate(event.x);
        double y = yAxis.getDataCoordinate(event.y);
        ISeries[] series = chart.getSeriesSet().getSeries();
        double minDist = Double.MAX_VALUE;
        ArrayList<SeriesData> foundSeries = new ArrayList<SeriesData>();
        int k = 0;
        while (k < series.length) {
            ISeries serie = series[k];
            double[] xS = serie.getXSeries();
            double[] yS = serie.getYSeries();
            int i = 0;
            while (i < xS.length) {
                double newDist = Math.sqrt(Math.pow(x - xS[i], 2.0) + Math.pow(y - yS[i], 2.0));
                if (newDist <= minDist) {
                    if (newDist < minDist) {
                        foundSeries.clear();
                    }
                    SeriesData data = new SeriesData(serie, xS[i], yS[i], k);
                    foundSeries.add(data);
                    minDist = newDist;
                }
                ++i;
            }
            ++k;
        }
        return foundSeries;
    }

    protected class SeriesData {
        double closestX = 0.0;
        double closestY = 0.0;
        int seriesIndex = 0;
        ISeries closestSerie = null;

        private SeriesData(ISeries serie, double x, double y, int idx) {
            this.closestSerie = serie;
            this.closestX = x;
            this.closestY = y;
            this.seriesIndex = idx;
        }
    }
}

