/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.AbstractChart;
import de.willuhn.jameica.hbci.gui.chart.ChartFeatureTooltip;
import de.willuhn.jameica.hbci.gui.chart.LineChartData;
import de.willuhn.jameica.hbci.gui.chart.LineStyle;
import de.willuhn.logging.Logger;
import de.willuhn.util.ColorGenerator;
import java.rmi.RemoteException;
import java.text.Format;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.IGrid;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;

public class LineChart
extends AbstractChart<LineChartData> {
    private boolean stacked = false;

    @Override
    public void redraw() throws RemoteException {
        ISeries[] series;
        if (this.getChart() == null || this.getChart().isDisposed()) {
            return;
        }
        ISeriesSet set = this.getChart().getSeriesSet();
        ISeries[] iSeriesArray = series = set.getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            set.deleteSeries(s.getId());
            ++n2;
        }
        List data = this.getData();
        int num = 1;
        int i = 0;
        while (i < data.size()) {
            LinkedList<Date> labelLine = new LinkedList<Date>();
            LinkedList<Number> dataLine = new LinkedList<Number>();
            LineChartData cd = (LineChartData)data.get(i);
            List list = cd.getData();
            String dataAttribute = cd.getDataAttribute();
            String labelAttribute = cd.getLabelAttribute();
            if (list == null || list.size() == 0 || dataAttribute == null || labelAttribute == null) {
                Logger.debug((String)"skipping data line, contains no data");
                dataLine.add(0.0);
                labelLine.add(new Date());
            } else {
                for (Object o : list) {
                    Object value = BeanUtil.get(o, (String)dataAttribute);
                    Object label = BeanUtil.get(o, (String)labelAttribute);
                    if (label == null || value == null || !(value instanceof Number) || !(label instanceof Date)) continue;
                    dataLine.add((Number)value);
                    labelLine.add((Date)label);
                }
            }
            String name = StringUtils.trimToEmpty((String)cd.getLabel());
            if (name.length() == 0) {
                name = String.valueOf(num) + ".";
                ++num;
            }
            ILineSeries lineSeries = (ILineSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.LINE, name);
            lineSeries.setXDateSeries(labelLine.toArray(new Date[0]));
            lineSeries.setYSeries(this.toArray(dataLine));
            LineStyle style = cd.getLineStyle();
            lineSeries.setLineStyle(style != null ? style.getSwtStyle() : org.eclipse.swtchart.LineStyle.SOLID);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.enableArea(true);
            lineSeries.setAntialias(1);
            lineSeries.enableStack(this.isStacked());
            lineSeries.enableStep(!cd.getCurve());
            lineSeries.setLineWidth(cd.getLineWidth());
            lineSeries.setVisibleInLegend(cd.isLegendEnabled());
            int[] cValues = cd.getColor();
            if (cValues == null) {
                cValues = ColorGenerator.create((int)(24 + i));
            }
            lineSeries.setLineColor(this.getColor(new RGB(cValues[0], cValues[1], cValues[2])));
            lineSeries.enableArea(cd.isFilled());
            ++i;
        }
        this.getChart().getAxisSet().adjustRange();
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        if (this.getChart() != null) {
            return;
        }
        this.addFeature(new ChartFeatureTooltip());
        this.setChart((Chart)new InteractiveChart(parent, 2048));
        this.getChart().setLayoutData((Object)new GridData(1808));
        this.getChart().setBackground(GUI.getDisplay().getSystemColor(1));
        this.getChart().setBackgroundInPlotArea(GUI.getDisplay().getSystemColor(1));
        ITitle title = this.getChart().getTitle();
        title.setText(this.getTitle());
        title.setForeground(GUI.getDisplay().getSystemColor(16));
        title.setFont(Font.BOLD.getSWTFont());
        ILegend legend = this.getChart().getLegend();
        legend.setFont(Font.SMALL.getSWTFont());
        legend.setPosition(131072);
        legend.setForeground(GUI.getDisplay().getSystemColor(16));
        Color gray = this.getColor(new RGB(234, 234, 234));
        IAxis axis = this.getChart().getAxisSet().getXAxis(0);
        axis.getTitle().setFont(Font.SMALL.getSWTFont());
        axis.getTitle().setForeground(GUI.getDisplay().getSystemColor(1));
        IGrid grid = axis.getGrid();
        grid.setStyle(org.eclipse.swtchart.LineStyle.DOT);
        grid.setForeground(gray);
        IAxisTick tick = axis.getTick();
        tick.setFormat((Format)HBCI.DATEFORMAT);
        tick.setForeground(GUI.getDisplay().getSystemColor(16));
        axis = this.getChart().getAxisSet().getYAxis(0);
        axis.getTitle().setVisible(false);
        grid = axis.getGrid();
        grid.setStyle(org.eclipse.swtchart.LineStyle.DOT);
        grid.setForeground(gray);
        tick = axis.getTick();
        tick.setFormat((Format)HBCI.DECIMALFORMAT);
        tick.setForeground(GUI.getDisplay().getSystemColor(16));
        this.redraw();
        super.paint(parent);
    }

    private double[] toArray(List<Number> list) {
        double[] values = new double[list.size()];
        int i = 0;
        while (i < list.size()) {
            values[i] = list.get(i).doubleValue();
            ++i;
        }
        return values;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean b) {
        this.stacked = b;
    }
}

