/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.chart;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.chart.AbstractChart;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.hbci.server.EinnahmeAusgabe;
import java.rmi.RemoteException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.IGrid;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesLabel;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;

public class VergleichBarChart
extends AbstractChart {
    private Composite comp = null;
    private List<EinnahmeAusgabeZeitraum> data = null;

    @Override
    public void redraw() throws RemoteException {
        if (this.comp == null || this.comp.isDisposed()) {
            return;
        }
        SWTUtil.disposeChildren((Composite)this.comp);
        this.comp.setLayout((Layout)SWTUtil.createGrid((int)1, (boolean)false));
        this.setChart((Chart)new InteractiveChart(this.comp, 2048));
        this.getChart().setLayoutData((Object)new GridData(1808));
        this.getChart().getLegend().setVisible(false);
        this.getChart().setOrientation(256);
        this.getChart().setBackground(GUI.getDisplay().getSystemColor(1));
        this.getChart().setBackgroundInPlotArea(GUI.getDisplay().getSystemColor(1));
        ITitle title = this.getChart().getTitle();
        title.setText(this.getTitle());
        title.setForeground(GUI.getDisplay().getSystemColor(16));
        title.setFont(Font.BOLD.getSWTFont());
        ILegend legend = this.getChart().getLegend();
        legend.setFont(Font.SMALL.getSWTFont());
        legend.setVisible(true);
        legend.setPosition(131072);
        legend.setForeground(GUI.getDisplay().getSystemColor(16));
        Color gray = this.getColor(new RGB(234, 234, 234));
        IAxis axis = this.getChart().getAxisSet().getXAxis(0);
        axis.getTitle().setFont(Font.SMALL.getSWTFont());
        axis.getTitle().setForeground(GUI.getDisplay().getSystemColor(1));
        IGrid grid = axis.getGrid();
        grid.setStyle(LineStyle.DOT);
        grid.setForeground(gray);
        IAxisTick tick = axis.getTick();
        tick.setFormat((Format)HBCI.DATEFORMAT);
        tick.setForeground(GUI.getDisplay().getSystemColor(16));
        axis.setCategorySeries(this.getCategoryNames());
        axis.enableCategory(true);
        axis = this.getChart().getAxisSet().getYAxis(0);
        axis.getTitle().setVisible(false);
        grid = axis.getGrid();
        grid.setStyle(LineStyle.DOT);
        grid.setForeground(gray);
        tick = axis.getTick();
        tick.setFormat((Format)HBCI.DECIMALFORMAT);
        tick.setForeground(GUI.getDisplay().getSystemColor(16));
        IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, "einnahmen");
        barSeries.setYSeries(this.getIncomeSeries());
        barSeries.setDescription(i18n.tr("Einnahmen"));
        barSeries.setBarColor(Settings.getBuchungHabenForeground());
        ISeriesLabel label = barSeries.getLabel();
        label.setFont(Font.SMALL.getSWTFont());
        label.setFormat(HBCI.DECIMALFORMAT.toPattern());
        label.setForeground(GUI.getDisplay().getSystemColor(2));
        label.setVisible(true);
        barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, "ausgaben");
        barSeries.setYSeries(this.getExpensesSeries());
        barSeries.setDescription(i18n.tr("Ausgaben"));
        barSeries.setBarColor(Settings.getBuchungSollForeground());
        label = barSeries.getLabel();
        label.setFont(Font.SMALL.getSWTFont());
        label.setFormat(HBCI.DECIMALFORMAT.toPattern());
        label.setForeground(GUI.getDisplay().getSystemColor(2));
        label.setVisible(true);
        this.getChart().getAxisSet().adjustRange();
        this.comp.layout(true);
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        if (this.comp != null) {
            return;
        }
        this.comp = new Composite(parent, 0);
        this.comp.setLayoutData((Object)new GridData(1808));
        this.redraw();
        super.paint(parent);
    }

    public void setData(List<EinnahmeAusgabeZeitraum> items) throws RemoteException {
        this.data = items;
    }

    private String[] getCategoryNames() {
        if (this.data == null) {
            return new String[]{i18n.tr("Keine Daten")};
        }
        ArrayList<String> result = new ArrayList<String>();
        for (EinnahmeAusgabeZeitraum n : this.data) {
            result.add(this.getLabel(n));
        }
        return result.toArray(new String[0]);
    }

    private String getLabel(EinnahmeAusgabeZeitraum node) {
        if (node instanceof EinnahmeAusgabe) {
            return node.getText();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(node.getStartdatum());
        int sm = cal.get(2);
        int sy = cal.get(1);
        cal.setTime(node.getEnddatum());
        int em = cal.get(2);
        int ey = cal.get(1);
        if (sm == em && sy == ey) {
            return String.valueOf(String.format("%02d", sm + 1)) + "/" + sy;
        }
        if (sy == ey) {
            return Integer.toString(sy);
        }
        return node.getText();
    }

    private double[] getIncomeSeries() throws RemoteException {
        if (this.data == null) {
            return new double[]{0.0};
        }
        double[] serie = new double[this.data.size()];
        int i = 0;
        while (i < this.data.size()) {
            EinnahmeAusgabeZeitraum e = this.data.get(i);
            serie[i] = e.getEinnahmen();
            ++i;
        }
        return serie;
    }

    private double[] getExpensesSeries() throws RemoteException {
        if (this.data == null) {
            return new double[]{0.0};
        }
        double[] serie = new double[this.data.size()];
        int i = 0;
        while (i < this.data.size()) {
            EinnahmeAusgabeZeitraum e = this.data.get(i);
            serie[i] = e.getAusgaben();
            ++i;
        }
        return serie;
    }
}

