/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.TextSchluessel;
import de.willuhn.jameica.hbci.gui.controller.AbstractTransferControl;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.ReminderIntervalInput;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.reminder.ReminderUtil;
import de.willuhn.jameica.hbci.rmi.BaseUeberweisung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;

public abstract class AbstractBaseUeberweisungControl
extends AbstractTransferControl {
    private TerminInput termin = null;
    private ReminderIntervalInput interval = null;

    public AbstractBaseUeberweisungControl(AbstractView view) {
        super(view);
    }

    public TerminInput getTermin() throws RemoteException {
        if (this.termin != null) {
            return this.termin;
        }
        this.termin = new TerminInput((Terminable)((Object)this.getTransfer()));
        return this.termin;
    }

    public ReminderIntervalInput getReminderInterval() throws Exception {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new ReminderIntervalInput((Terminable)((Object)this.getTransfer()), (Date)this.getTermin().getValue());
        return this.interval;
    }

    public abstract Input getTextSchluessel() throws RemoteException;

    @Override
    public synchronized boolean handleStore() {
        block11: {
            BaseUeberweisung bu;
            block10: {
                block9: {
                    bu = null;
                    bu = (BaseUeberweisung)this.getTransfer();
                    if (!bu.ausgefuehrt()) break block9;
                    return true;
                }
                Date termin = (Date)this.getTermin().getValue();
                bu.setTermin(termin);
                TextSchluessel s = (TextSchluessel)this.getTextSchluessel().getValue();
                bu.setTextSchluessel(s == null ? null : s.getCode());
                bu.transactionBegin();
                if (!super.handleStore()) break block10;
                ReminderIntervalInput input = this.getReminderInterval();
                if (input.containsInterval()) {
                    ReminderUtil.apply(bu, (ReminderInterval)input.getValue(), input.getEnd());
                }
                bu.transactionCommit();
                return true;
            }
            try {
                bu.transactionRollback();
            }
            catch (Exception e) {
                if (bu != null) {
                    try {
                        bu.transactionRollback();
                    }
                    catch (Exception xe) {
                        Logger.error((String)"rollback failed", (Throwable)xe);
                    }
                }
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                    break block11;
                }
                Logger.error((String)"error while saving order", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
            }
        }
        return false;
    }

    @Override
    public Input getBetrag() throws RemoteException {
        Input i = super.getBetrag();
        if (((Terminable)((Object)this.getTransfer())).ausgefuehrt()) {
            i.disable();
        }
        return i;
    }

    @Override
    public TextInput getEmpfaengerBlz() throws RemoteException {
        TextInput i = super.getEmpfaengerBlz();
        if (((Terminable)((Object)this.getTransfer())).ausgefuehrt()) {
            i.disable();
        }
        return i;
    }

    @Override
    public TextInput getEmpfaengerKonto() throws RemoteException {
        TextInput i = super.getEmpfaengerKonto();
        if (((Terminable)((Object)this.getTransfer())).ausgefuehrt()) {
            i.disable();
        }
        return i;
    }

    @Override
    public AddressInput getEmpfaengerName() throws RemoteException {
        AddressInput i = super.getEmpfaengerName();
        if (((Terminable)((Object)this.getTransfer())).ausgefuehrt()) {
            i.disable();
        }
        return i;
    }

    @Override
    public KontoInput getKontoAuswahl() throws RemoteException {
        KontoInput i = super.getKontoAuswahl();
        i.setEnabled(!((Terminable)((Object)this.getTransfer())).ausgefuehrt());
        return i;
    }

    @Override
    public CheckboxInput getStoreEmpfaenger() throws RemoteException {
        CheckboxInput i = super.getStoreEmpfaenger();
        if (((Terminable)((Object)this.getTransfer())).ausgefuehrt()) {
            i.disable();
        }
        return i;
    }

    @Override
    public TextInput getZweck() throws RemoteException {
        TextInput i = super.getZweck();
        i.setEnabled(!((Terminable)((Object)this.getTransfer())).ausgefuehrt());
        return i;
    }

    @Override
    public DialogInput getZweck2() throws RemoteException {
        DialogInput i = super.getZweck2();
        if (((Terminable)((Object)this.getTransfer())).ausgefuehrt()) {
            i.disableClientControl();
        }
        return i;
    }
}

