/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.dialogs.VerwendungszweckDialog;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractSammelTransferBuchungControl
extends AbstractControl {
    private Address gegenKonto = null;
    private Input betrag = null;
    private TextInput zweck = null;
    private DialogInput zweck2 = null;
    VerwendungszweckDialog zweckDialog = null;
    private AddressInput gkName = null;
    private TextInput gkNummer = null;
    private TextInput gkBLZ = null;
    private CheckboxInput storeAddress = null;
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public AbstractSammelTransferBuchungControl(AbstractView view) {
        super(view);
    }

    public abstract SammelTransferBuchung getBuchung();

    public AddressInput getGegenkontoName() throws RemoteException {
        if (this.gkName != null) {
            return this.gkName;
        }
        this.gkName = new AddressInput(this.getBuchung().getGegenkontoName(), AddressFilter.INLAND);
        this.gkName.setMandatory(true);
        this.gkName.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        this.gkName.addListener(new GegenkontoListener());
        return this.gkName;
    }

    public TextInput getGegenKonto() throws RemoteException {
        if (this.gkNummer != null) {
            return this.gkNummer;
        }
        this.gkNummer = new TextInput(this.getBuchung().getGegenkontoNummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
        this.gkNummer.setValidChars(String.valueOf(HBCIProperties.HBCI_KTO_VALIDCHARS) + " ");
        this.gkNummer.setMandatory(true);
        this.gkNummer.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        this.gkNummer.addListener(new Listener(){

            public void handleEvent(Event event) {
                String s = (String)AbstractSammelTransferBuchungControl.this.gkNummer.getValue();
                if (s == null || s.length() == 0 || s.indexOf(" ") == -1) {
                    return;
                }
                AbstractSammelTransferBuchungControl.this.gkNummer.setValue((Object)s.replaceAll(" ", ""));
            }
        });
        return this.gkNummer;
    }

    public Input getGegenkontoBLZ() throws RemoteException {
        if (this.gkBLZ != null) {
            return this.gkBLZ;
        }
        this.gkBLZ = new BLZInput(this.getBuchung().getGegenkontoBLZ());
        this.gkBLZ.setMandatory(true);
        this.gkBLZ.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        return this.gkBLZ;
    }

    public Input getZweck() throws RemoteException {
        if (this.zweck != null) {
            return this.zweck;
        }
        this.zweck = new TextInput(this.getBuchung().getZweck(), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        this.zweck.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        this.zweck.setMandatory(true);
        this.zweck.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        return this.zweck;
    }

    public DialogInput getZweck2() throws RemoteException {
        if (this.zweck2 != null) {
            return this.zweck2;
        }
        String buttonText = "weitere Zeilen ({0})...";
        this.zweckDialog = new VerwendungszweckDialog(this.getBuchung(), 0);
        this.zweckDialog.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    String[] newLines = (String[])AbstractSammelTransferBuchungControl.this.zweckDialog.getData();
                    if (newLines != null) {
                        AbstractSammelTransferBuchungControl.this.zweck2.setButtonText(AbstractSammelTransferBuchungControl.this.i18n.tr("weitere Zeilen ({0})...", String.valueOf(newLines.length)));
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to update line count", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(AbstractSammelTransferBuchungControl.this.i18n.tr("Fehler beim Aktualisieren der Zeilen-Anzahl"), 1));
                }
            }
        });
        this.zweck2 = new DialogInput(this.getBuchung().getZweck2(), (AbstractDialog)this.zweckDialog);
        this.zweck2.setButtonText(this.i18n.tr("weitere Zeilen ({0})...", String.valueOf(this.getBuchung().getWeitereVerwendungszwecke().length)));
        this.zweck2.setMaxLength(HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        this.zweck2.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        if (this.getBuchung().getSammelTransfer().ausgefuehrt()) {
            this.zweck2.disableClientControl();
        }
        return this.zweck2;
    }

    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        SammelTransferBuchung b = this.getBuchung();
        double d = b.getBetrag();
        if (d == 0.0) {
            d = Double.NaN;
        }
        this.betrag = new DecimalInput(d, HBCI.DECIMALFORMAT);
        this.betrag.setMandatory(true);
        this.betrag.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        try {
            String curr = this.getBuchung().getSammelTransfer().getKonto().getWaehrung();
            if (curr != null) {
                this.betrag.setComment(curr);
            }
        }
        catch (Exception e) {
            Logger.error((String)"error while reading currency name", (Throwable)e);
        }
        return this.betrag;
    }

    public abstract SelectInput getTextSchluessel() throws RemoteException;

    public CheckboxInput getStoreAddress() throws RemoteException {
        if (this.storeAddress != null) {
            return this.storeAddress;
        }
        this.storeAddress = new CheckboxInput(this.getBuchung().isNewObject());
        this.storeAddress.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        return this.storeAddress;
    }

    public abstract void handleStore(boolean var1);

    private class GegenkontoListener
    implements Listener {
        private GegenkontoListener() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                return;
            }
            AbstractSammelTransferBuchungControl.this.gegenKonto = (Address)event.data;
            if (AbstractSammelTransferBuchungControl.this.gegenKonto == null) {
                return;
            }
            try {
                AbstractSammelTransferBuchungControl.this.getGegenKonto().setValue((Object)AbstractSammelTransferBuchungControl.this.gegenKonto.getKontonummer());
                AbstractSammelTransferBuchungControl.this.getGegenkontoBLZ().setValue((Object)AbstractSammelTransferBuchungControl.this.gegenKonto.getBlz());
                AbstractSammelTransferBuchungControl.this.getGegenkontoName().setText(AbstractSammelTransferBuchungControl.this.gegenKonto.getName());
                AbstractSammelTransferBuchungControl.this.getStoreAddress().setValue((Object)Boolean.FALSE);
                try {
                    String zweck = (String)AbstractSammelTransferBuchungControl.this.getZweck().getValue();
                    String zweck2 = AbstractSammelTransferBuchungControl.this.getZweck2().getText();
                    if (zweck != null && zweck.length() > 0 || zweck2 != null && zweck2.length() > 0) {
                        return;
                    }
                    DBIterator list = AbstractSammelTransferBuchungControl.this.getBuchung().getList();
                    list.addFilter("gegenkonto_nr = ?", new Object[]{AbstractSammelTransferBuchungControl.this.gegenKonto.getKontonummer()});
                    list.addFilter("gegenkonto_blz = ?", new Object[]{AbstractSammelTransferBuchungControl.this.gegenKonto.getBlz()});
                    list.setOrder("order by id desc");
                    if (list.hasNext()) {
                        SammelTransferBuchung t = (SammelTransferBuchung)list.next();
                        AbstractSammelTransferBuchungControl.this.getZweck().setValue((Object)t.getZweck());
                        AbstractSammelTransferBuchungControl.this.getZweck2().setText(t.getZweck2());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to autocomplete subject", (Throwable)e);
                }
            }
            catch (RemoteException er) {
                Logger.error((String)"error while choosing address", (Throwable)er);
                GUI.getStatusBar().setErrorText(AbstractSammelTransferBuchungControl.this.i18n.tr("Fehler bei der Auswahl der Adresse"));
            }
        }
    }
}

