/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.ReminderIntervalInput;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.reminder.ReminderUtil;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractSammelTransferControl<T extends SammelTransfer>
extends AbstractControl {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private KontoInput kontoAuswahl = null;
    private Input name = null;
    private TerminInput termin = null;
    private ReminderIntervalInput interval = null;
    private Input summe = null;

    public AbstractSammelTransferControl(AbstractView view) {
        super(view);
    }

    public abstract T getTransfer() throws RemoteException;

    public abstract TablePart getListe() throws RemoteException;

    public abstract TablePart getBuchungen() throws RemoteException;

    public KontoInput getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        Konto k = this.getTransfer().getKonto();
        KontoListener kl = new KontoListener();
        this.kontoAuswahl = new KontoInput(k, this.getTransfer().isNewObject() ? KontoFilter.ONLINE : KontoFilter.ALL);
        this.kontoAuswahl.setRememberSelection("auftraege", false);
        this.kontoAuswahl.setMandatory(true);
        this.kontoAuswahl.addListener(kl);
        this.kontoAuswahl.setEnabled(!this.getTransfer().ausgefuehrt());
        kl.handleEvent(null);
        return this.kontoAuswahl;
    }

    public TerminInput getTermin() throws RemoteException {
        if (this.termin == null) {
            this.termin = new TerminInput((Terminable)this.getTransfer());
        }
        return this.termin;
    }

    public ReminderIntervalInput getReminderInterval() throws Exception {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new ReminderIntervalInput((Terminable)this.getTransfer(), (Date)this.getTermin().getValue());
        return this.interval;
    }

    public Input getSumme() throws RemoteException {
        if (this.summe != null) {
            return this.summe;
        }
        this.summe = new LabelInput(HBCI.DECIMALFORMAT.format(this.getTransfer().getSumme()));
        Konto k = this.getTransfer().getKonto();
        this.summe.setComment(k != null ? k.getWaehrung() : "");
        return this.summe;
    }

    public Input getName() throws RemoteException {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput(this.getTransfer().getBezeichnung());
        this.name.setMandatory(true);
        this.name.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.name;
    }

    public synchronized boolean handleStore() {
        SammelTransfer t;
        block9: {
            t = null;
            try {
                t = (SammelTransfer)this.getTransfer();
                if (!t.ausgefuehrt()) break block9;
                return true;
            }
            catch (Exception e) {
                if (t != null) {
                    try {
                        t.transactionRollback();
                    }
                    catch (Exception xe) {
                        Logger.error((String)"rollback failed", (Throwable)xe);
                    }
                }
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        t.transactionBegin();
        t.setKonto((Konto)this.getKontoAuswahl().getValue());
        t.setBezeichnung((String)this.getName().getValue());
        t.setTermin((Date)this.getTermin().getValue());
        t.store();
        ReminderIntervalInput input = this.getReminderInterval();
        if (input.containsInterval()) {
            ReminderUtil.apply(t, (ReminderInterval)input.getValue(), input.getEnd());
        }
        t.transactionCommit();
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Sammel-Auftrag gespeichert"), 0));
        return true;
    }

    class CreateMenuItem
    extends ContextMenuItem {
        public CreateMenuItem(final Action action) {
            super(i18n.tr("Neue Buchung..."), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    if (AbstractSammelTransferControl.this.handleStore()) {
                        try {
                            action.handleAction(AbstractSammelTransferControl.this.getTransfer());
                        }
                        catch (RemoteException e) {
                            Logger.error((String)"unable to load sammelueberweisung", (Throwable)e);
                            throw new ApplicationException(i18n.tr("Fehler beim Laden des Sammel-Auftrages"));
                        }
                    }
                }
            }, "text-x-generic.png");
        }

        public boolean isEnabledFor(Object o) {
            try {
                return !AbstractSammelTransferControl.this.getTransfer().ausgefuehrt() && super.isEnabledFor(o);
            }
            catch (Exception e) {
                Logger.error((String)"error while checking menu item", (Throwable)e);
                return false;
            }
        }
    }

    class DeleteMenuItem
    extends CheckedContextMenuItem {
        public DeleteMenuItem() {
            super(i18n.tr("Buchung(en) l\u00f6schen..."), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    new DBObjectDelete().handleAction(context);
                    try {
                        AbstractSammelTransferControl.this.getSumme().setValue((Object)HBCI.DECIMALFORMAT.format(AbstractSammelTransferControl.this.getTransfer().getSumme()));
                    }
                    catch (RemoteException e) {
                        Logger.error((String)"unable to refresh summary", (Throwable)e);
                    }
                }
            }, "user-trash-full.png");
        }

        public boolean isEnabledFor(Object o) {
            if (o == null) {
                return false;
            }
            try {
                return !AbstractSammelTransferControl.this.getTransfer().ausgefuehrt() && super.isEnabledFor(o);
            }
            catch (Exception e) {
                Logger.error((String)"error while checking menu item", (Throwable)e);
                return false;
            }
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = AbstractSammelTransferControl.this.getKontoAuswahl().getValue();
                if (o == null || !(o instanceof Konto)) {
                    return;
                }
                Konto konto = (Konto)o;
                AbstractSammelTransferControl.this.getTransfer().setKonto(konto);
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating konto", (Throwable)er);
            }
        }
    }
}

