/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.HibiscusAddressUpdate;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.input.PurposeCodeInput;
import de.willuhn.jameica.hbci.gui.input.StoreAddressInput;
import de.willuhn.jameica.hbci.gui.input.ZweckInput;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageBus;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractSepaSammelTransferBuchungControl<T extends SepaSammelTransferBuchung>
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Input betrag = null;
    private ZweckInput zweck = null;
    private AddressInput empfName = null;
    private TextInput empfkto = null;
    private TextInput bic = null;
    private TextInput endToEndId = null;
    private PurposeCodeInput purposeCode = null;
    private CheckboxInput storeEmpfaenger = null;
    private HibiscusAddressUpdate aUpdate = new HibiscusAddressUpdate();

    public AbstractSepaSammelTransferBuchungControl(AbstractView view) {
        super(view);
    }

    public abstract T getBuchung();

    public AddressInput getEmpfaengerName() throws RemoteException {
        if (this.empfName != null) {
            return this.empfName;
        }
        T s = this.getBuchung();
        this.empfName = new AddressInput(s.getGegenkontoName(), AddressFilter.FOREIGN);
        this.empfName.setMandatory(true);
        this.empfName.addListener(new EmpfaengerListener());
        this.empfName.setEnabled(!s.getSammelTransfer().ausgefuehrt());
        return this.empfName;
    }

    public TextInput getEmpfaengerKonto() throws RemoteException {
        if (this.empfkto != null) {
            return this.empfkto;
        }
        T s = this.getBuchung();
        this.empfkto = new IBANInput(s.getGegenkontoNummer(), this.getEmpfaengerBic());
        this.empfkto.setValidChars(HBCIProperties.HBCI_IBAN_VALIDCHARS);
        this.empfkto.setMandatory(true);
        this.empfkto.setEnabled(!s.getSammelTransfer().ausgefuehrt());
        return this.empfkto;
    }

    public Input getEmpfaengerBic() throws RemoteException {
        if (this.bic != null) {
            return this.bic;
        }
        T s = this.getBuchung();
        this.bic = new BICInput(s.getGegenkontoBLZ());
        this.bic.setEnabled(!s.getSammelTransfer().ausgefuehrt());
        return this.bic;
    }

    public Input getEndToEndId() throws RemoteException {
        if (this.endToEndId != null) {
            return this.endToEndId;
        }
        T s = this.getBuchung();
        this.endToEndId = new TextInput(s.getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
        this.endToEndId.setName(i18n.tr("End-to-End ID"));
        this.endToEndId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
        this.endToEndId.setEnabled(!s.getSammelTransfer().ausgefuehrt());
        this.endToEndId.setHint(i18n.tr("freilassen wenn nicht ben\u00f6tigt"));
        this.endToEndId.setMandatory(false);
        return this.endToEndId;
    }

    public Input getPurposeCode() throws RemoteException {
        if (this.purposeCode != null) {
            return this.purposeCode;
        }
        T s = this.getBuchung();
        this.purposeCode = new PurposeCodeInput(this.getBuchung().getPurposeCode());
        this.purposeCode.setEnabled(!s.getSammelTransfer().ausgefuehrt());
        this.purposeCode.setMandatory(false);
        return this.purposeCode;
    }

    public Input getZweck() throws RemoteException {
        if (this.zweck != null) {
            return this.zweck;
        }
        T s = this.getBuchung();
        this.zweck = new ZweckInput(s.getZweck());
        this.zweck.setEnabled(!s.getSammelTransfer().ausgefuehrt());
        return this.zweck;
    }

    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        T s = this.getBuchung();
        Object t = s.getSammelTransfer();
        double d = s.getBetrag();
        if (Math.abs(d) < 0.01) {
            d = Double.NaN;
        }
        this.betrag = new DecimalInput(d, HBCI.DECIMALFORMAT);
        this.betrag.setComment(t.getKonto().getWaehrung());
        this.betrag.setMandatory(true);
        this.betrag.setEnabled(!t.ausgefuehrt());
        return this.betrag;
    }

    public CheckboxInput getStoreEmpfaenger() throws RemoteException {
        if (this.storeEmpfaenger != null) {
            return this.storeEmpfaenger;
        }
        this.storeEmpfaenger = new StoreAddressInput(this.getBuchung());
        return this.storeEmpfaenger;
    }

    protected synchronized void store() throws Exception {
        T s = this.getBuchung();
        if (s.getSammelTransfer().ausgefuehrt()) {
            return;
        }
        Double d = (Double)this.getBetrag().getValue();
        s.setBetrag(d == null ? Double.NaN : d);
        s.setZweck((String)this.getZweck().getValue());
        s.setEndtoEndId((String)this.getEndToEndId().getValue());
        s.setPurposeCode((String)this.getPurposeCode().getValue());
        String kto = (String)this.getEmpfaengerKonto().getValue();
        String name = this.getEmpfaengerName().getText();
        String bic = (String)this.getEmpfaengerBic().getValue();
        s.setGegenkontoNummer(kto);
        s.setGegenkontoName(name);
        s.setGegenkontoBLZ(bic);
        s.store();
        Boolean store = (Boolean)this.getStoreEmpfaenger().getValue();
        this.aUpdate.setCreate(store);
        HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
        e.setIban(kto);
        e.setName(name);
        e.setBic(bic);
        this.aUpdate.handleAction(e);
        if (e.getID() != null) {
            MetaKey.ADDRESS_ID.set((HibiscusDBObject)s, e.getID());
        }
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Buchung gespeichert"), 0));
        MessageBus.send((String)"hibiscus.transfer.check", s);
    }

    public synchronized boolean handleStore() {
        block5: {
            try {
                T s = this.getBuchung();
                Object t = s.getSammelTransfer();
                if (!t.ausgefuehrt()) break block5;
                return true;
            }
            catch (Exception e) {
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        this.store();
        return true;
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                return;
            }
            if (!(event.data instanceof Address)) {
                return;
            }
            Address a = (Address)event.data;
            AbstractSepaSammelTransferBuchungControl.this.aUpdate.setAddress(a);
            try {
                AbstractSepaSammelTransferBuchungControl.this.getEmpfaengerName().setText(a.getName());
                AbstractSepaSammelTransferBuchungControl.this.getEmpfaengerKonto().setValue((Object)a.getIban());
                AbstractSepaSammelTransferBuchungControl.this.getEmpfaengerBic().setValue((Object)a.getBic());
                AbstractSepaSammelTransferBuchungControl.this.getStoreEmpfaenger().setValue((Object)Boolean.FALSE);
                try {
                    String zweck = StringUtils.trimToNull((String)((String)AbstractSepaSammelTransferBuchungControl.this.getZweck().getValue()));
                    if (zweck == null) {
                        Object s = AbstractSepaSammelTransferBuchungControl.this.getBuchung();
                        DBIterator list = s.getList();
                        list.addFilter("empfaenger_konto = ?", new Object[]{a.getIban()});
                        list.addFilter("empfaenger_name = ?", new Object[]{a.getName()});
                        list.setOrder("order by id desc");
                        if (list.hasNext()) {
                            SepaSammelTransferBuchung t = (SepaSammelTransferBuchung)list.next();
                            AbstractSepaSammelTransferBuchungControl.this.getZweck().setValue((Object)t.getZweck());
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to autocomplete subject", (Throwable)e);
                }
            }
            catch (Exception e) {
                Logger.error((String)"error while choosing empfaenger", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei der Auswahl des Gegenkontos"), 1));
            }
        }
    }
}

