/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.BatchBookInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.ReminderIntervalInput;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.reminder.ReminderUtil;
import de.willuhn.jameica.hbci.rmi.BatchBookType;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractSepaSammelTransferControl<T extends SepaSammelTransfer>
extends AbstractControl {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private KontoInput kontoAuswahl = null;
    private Input name = null;
    private TerminInput termin = null;
    private ReminderIntervalInput interval = null;
    private BatchBookInput batchbook = null;
    private TextInput pmtInfId = null;

    public AbstractSepaSammelTransferControl(AbstractView view) {
        super(view);
    }

    public abstract T getTransfer() throws RemoteException;

    public abstract Class<? extends SynchronizeJob> getSynchronizeJobType();

    public abstract TablePart getListe() throws RemoteException;

    public abstract TablePart getBuchungen() throws RemoteException;

    public Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        KontoListener kl = new KontoListener();
        MyKontoFilter filter = new MyKontoFilter();
        this.kontoAuswahl = new KontoInput(this.getTransfer().getKonto(), filter);
        this.kontoAuswahl.setName(i18n.tr("Pers\u00f6nliches Konto"));
        this.kontoAuswahl.setRememberSelection("auftraege", false);
        this.kontoAuswahl.setMandatory(true);
        this.kontoAuswahl.addListener(kl);
        this.kontoAuswahl.setEnabled(!this.getTransfer().ausgefuehrt());
        kl.handleEvent(null);
        if (!filter.found) {
            this.kontoAuswahl.setComment(i18n.tr("Bitte tragen Sie IBAN/BIC in Ihrem Konto ein"));
        }
        return this.kontoAuswahl;
    }

    public BatchBookInput getBatchBook() throws RemoteException {
        if (this.batchbook != null) {
            return this.batchbook;
        }
        T t = this.getTransfer();
        this.batchbook = new BatchBookInput(t.getKonto(), (HibiscusDBObject)t);
        this.batchbook.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.batchbook;
    }

    public TerminInput getTermin() throws RemoteException {
        if (this.termin == null) {
            this.termin = new TerminInput((Terminable)this.getTransfer());
        }
        return this.termin;
    }

    public ReminderIntervalInput getReminderInterval() throws RemoteException {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new ReminderIntervalInput((Terminable)this.getTransfer(), (Date)this.getTermin().getValue());
        return this.interval;
    }

    public Input getName() throws RemoteException {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput(this.getTransfer().getBezeichnung());
        this.name.setMandatory(true);
        this.name.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.name;
    }

    public Input getPmtInfId() throws RemoteException {
        if (this.pmtInfId != null) {
            return this.pmtInfId;
        }
        this.pmtInfId = new TextInput(this.getTransfer().getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
        this.pmtInfId.setName(i18n.tr("Referenz (Payment-Information ID)"));
        this.pmtInfId.setValidChars(HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
        this.pmtInfId.setEnabled(!this.getTransfer().ausgefuehrt());
        this.pmtInfId.setHint(i18n.tr("freilassen wenn nicht ben\u00f6tigt"));
        this.pmtInfId.setMandatory(false);
        return this.pmtInfId;
    }

    public synchronized void store() throws Exception {
        T t = this.getTransfer();
        if (t.ausgefuehrt()) {
            return;
        }
        Konto k = (Konto)this.getKontoAuswahl().getValue();
        t.setKonto(k);
        t.setBezeichnung((String)this.getName().getValue());
        t.setTermin((Date)this.getTermin().getValue());
        t.setPmtInfId((String)this.getPmtInfId().getValue());
        t.store();
        BatchBookType batch = (BatchBookType)((Object)this.getBatchBook().getValue());
        String value = batch != null ? batch.getValue() : null;
        MetaKey.SEPA_BATCHBOOK.set((HibiscusDBObject)t, value);
        MetaKey.SEPA_BATCHBOOK.set(k, t.getClass().getSimpleName(), value);
        ReminderIntervalInput input = this.getReminderInterval();
        if (input.containsInterval()) {
            ReminderUtil.apply(t, (ReminderInterval)input.getValue(), input.getEnd());
        }
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("SEPA-Sammelauftrag gespeichert"), 0));
    }

    public synchronized boolean handleStore() {
        block5: {
            try {
                T t = this.getTransfer();
                if (!t.ausgefuehrt()) break block5;
                return true;
            }
            catch (Exception e) {
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        this.store();
        return true;
    }

    class CreateMenuItem
    extends ContextMenuItem {
        public CreateMenuItem(final Action action) {
            super(i18n.tr("Neue Buchung..."), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    try {
                        if (AbstractSepaSammelTransferControl.this.handleStore()) {
                            action.handleAction(AbstractSepaSammelTransferControl.this.getTransfer());
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                    }
                    catch (ApplicationException ae) {
                        throw ae;
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to store transfer", (Throwable)e);
                        throw new ApplicationException(i18n.tr("Erstellen der Buchung fehlgeschlagen: {0}", e.getMessage()));
                    }
                }
            }, "text-x-generic.png");
        }

        public boolean isEnabledFor(Object o) {
            try {
                return !AbstractSepaSammelTransferControl.this.getTransfer().ausgefuehrt() && super.isEnabledFor(o);
            }
            catch (Exception e) {
                Logger.error((String)"error while checking menu item", (Throwable)e);
                return false;
            }
        }
    }

    class DeleteMenuItem
    extends CheckedContextMenuItem {
        public DeleteMenuItem() {
            super(i18n.tr("Buchung(en) l\u00f6schen..."), (Action)new DBObjectDelete(), "user-trash-full.png");
        }

        public boolean isEnabledFor(Object o) {
            if (o == null) {
                return false;
            }
            try {
                return !AbstractSepaSammelTransferControl.this.getTransfer().ausgefuehrt() && super.isEnabledFor(o);
            }
            catch (Exception e) {
                Logger.error((String)"error while checking menu item", (Throwable)e);
                return false;
            }
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = AbstractSepaSammelTransferControl.this.getKontoAuswahl().getValue();
                if (o == null || !(o instanceof Konto)) {
                    return;
                }
                Konto konto = (Konto)o;
                Object transfer = AbstractSepaSammelTransferControl.this.getTransfer();
                transfer.setKonto(konto);
                AbstractSepaSammelTransferControl.this.getBatchBook().update(konto, (HibiscusDBObject)transfer);
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating konto", (Throwable)er);
            }
        }
    }

    private class MyKontoFilter
    extends KontoFilter {
        private KontoFilter foreign;
        private boolean found;

        private MyKontoFilter() {
            this.foreign = KontoFilter.createForeign(AbstractSepaSammelTransferControl.this.getSynchronizeJobType());
            this.found = false;
        }

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            boolean b = this.foreign.accept(konto);
            this.found |= b;
            return b;
        }
    }
}

