/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerAdd;
import de.willuhn.jameica.hbci.gui.dialogs.VerwendungszweckDialog;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.AccountInput;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.StoreAddressInput;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractTransferControl
extends AbstractControl {
    private Address gegenkonto = null;
    private Konto konto = null;
    private KontoInput kontoAuswahl = null;
    private Input betrag = null;
    private TextInput zweck = null;
    private DialogInput zweck2 = null;
    private VerwendungszweckDialog zweckDialog = null;
    private AddressInput empfName = null;
    private TextInput empfkto = null;
    private TextInput empfblz = null;
    private CheckboxInput storeEmpfaenger = null;
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public AbstractTransferControl(AbstractView view) {
        super(view);
    }

    public abstract HibiscusTransfer getTransfer() throws RemoteException;

    public Konto getKonto() throws RemoteException {
        if (this.konto != null) {
            return this.konto;
        }
        this.konto = this.getTransfer().getKonto();
        return this.konto;
    }

    public KontoInput getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        Konto k = this.getKonto();
        KontoListener kl = new KontoListener();
        this.kontoAuswahl = new KontoInput(k, this.getTransfer().isNewObject() ? KontoFilter.ONLINE : KontoFilter.ALL);
        this.kontoAuswahl.setRememberSelection("auftraege", false);
        this.kontoAuswahl.setName(i18n.tr("Pers\u00f6nliches Konto"));
        this.kontoAuswahl.setMandatory(true);
        this.kontoAuswahl.addListener(kl);
        kl.handleEvent(null);
        return this.kontoAuswahl;
    }

    public AddressInput getEmpfaengerName() throws RemoteException {
        if (this.empfName != null) {
            return this.empfName;
        }
        this.empfName = new AddressInput(this.getTransfer().getGegenkontoName(), AddressFilter.INLAND);
        this.empfName.setName(i18n.tr("Name"));
        this.empfName.setMandatory(true);
        this.empfName.addListener(new EmpfaengerListener());
        return this.empfName;
    }

    public TextInput getEmpfaengerKonto() throws RemoteException {
        if (this.empfkto != null) {
            return this.empfkto;
        }
        this.empfkto = new AccountInput(this.getTransfer().getGegenkontoNummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
        this.empfkto.setName(i18n.tr("Kontonummer"));
        this.empfkto.setComment("");
        this.empfkto.setValidChars(HBCIProperties.HBCI_KTO_VALIDCHARS);
        this.empfkto.setMandatory(true);
        this.empfkto.addListener((Listener)new KontonummerListener());
        return this.empfkto;
    }

    public TextInput getEmpfaengerBlz() throws RemoteException {
        if (this.empfblz != null) {
            return this.empfblz;
        }
        this.empfblz = new BLZInput(this.getTransfer().getGegenkontoBLZ());
        this.empfblz.addListener((Listener)new KontonummerListener());
        this.empfblz.setMandatory(true);
        return this.empfblz;
    }

    public TextInput getZweck() throws RemoteException {
        if (this.zweck != null) {
            return this.zweck;
        }
        this.zweck = new TextInput(this.getTransfer().getZweck(), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        this.zweck.setName(i18n.tr("Verwendungszweck"));
        this.zweck.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        this.zweck.setMandatory(true);
        return this.zweck;
    }

    public DialogInput getZweck2() throws RemoteException {
        if (this.zweck2 != null) {
            return this.zweck2;
        }
        String buttonText = "weitere Zeilen ({0})...";
        this.zweckDialog = new VerwendungszweckDialog(this.getTransfer(), 0);
        this.zweckDialog.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    String[] newLines = (String[])AbstractTransferControl.this.zweckDialog.getData();
                    if (newLines != null) {
                        AbstractTransferControl.this.zweck2.setButtonText(i18n.tr("weitere Zeilen ({0})...", String.valueOf(newLines.length)));
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to update line count", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Zeilen-Anzahl"), 1));
                }
            }
        });
        this.zweck2 = new DialogInput(this.getTransfer().getZweck2(), (AbstractDialog)this.zweckDialog);
        this.zweck2.setName(i18n.tr("weiterer Verwendungszweck"));
        this.zweck2.setButtonText(i18n.tr("weitere Zeilen ({0})...", String.valueOf(this.getTransfer().getWeitereVerwendungszwecke().length)));
        this.zweck2.setMaxLength(HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        this.zweck2.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        return this.zweck2;
    }

    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        HibiscusTransfer t = this.getTransfer();
        double d = t.getBetrag();
        if (d == 0.0) {
            d = Double.NaN;
        }
        this.betrag = new DecimalInput(d, HBCI.DECIMALFORMAT);
        this.betrag.setName(i18n.tr("Betrag"));
        this.betrag.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        this.betrag.setMandatory(true);
        return this.betrag;
    }

    public CheckboxInput getStoreEmpfaenger() throws RemoteException {
        if (this.storeEmpfaenger != null) {
            return this.storeEmpfaenger;
        }
        this.storeEmpfaenger = new StoreAddressInput(this.getTransfer());
        return this.storeEmpfaenger;
    }

    public synchronized boolean handleStore() {
        HibiscusTransfer t = null;
        try {
            t = this.getTransfer();
            t.transactionBegin();
            Double d = (Double)this.getBetrag().getValue();
            t.setBetrag(d == null ? Double.NaN : d);
            t.setKonto((Konto)this.getKontoAuswahl().getValue());
            t.setZweck((String)this.getZweck().getValue());
            t.setZweck2(this.getZweck2().getText());
            String kto = (String)this.getEmpfaengerKonto().getValue();
            String blz = (String)this.getEmpfaengerBlz().getValue();
            String name = this.getEmpfaengerName().getText();
            t.setGegenkontoNummer(kto);
            t.setGegenkontoBLZ(blz);
            t.setGegenkontoName(name);
            String[] lines = (String[])this.zweckDialog.getData();
            if (lines != null) {
                t.setWeitereVerwendungszwecke(lines);
            }
            t.store();
            Boolean store = (Boolean)this.getStoreEmpfaenger().getValue();
            if (store.booleanValue()) {
                HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
                e.setBlz(blz);
                e.setKontonummer(kto);
                e.setName(name);
                new EmpfaengerAdd().handleAction(e);
            }
            t.transactionCommit();
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Auftrag gespeichert"), 0));
            if (t.getBetrag() > Settings.getUeberweisungLimit()) {
                GUI.getView().setErrorText(i18n.tr("Warnung: Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.getKonto().getWaehrung()));
            }
            return true;
        }
        catch (Exception e) {
            if (t != null) {
                try {
                    t.transactionRollback();
                }
                catch (Exception xe) {
                    Logger.error((String)"rollback failed", (Throwable)xe);
                }
            }
            if (e instanceof ApplicationException) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
            } else {
                Logger.error((String)"error while saving order", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
            }
            return false;
        }
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                return;
            }
            AbstractTransferControl.this.gegenkonto = (Address)event.data;
            if (AbstractTransferControl.this.gegenkonto == null) {
                return;
            }
            try {
                AbstractTransferControl.this.getEmpfaengerName().setText(AbstractTransferControl.this.gegenkonto.getName());
                AbstractTransferControl.this.getEmpfaengerKonto().setValue((Object)AbstractTransferControl.this.gegenkonto.getKontonummer());
                AbstractTransferControl.this.getEmpfaengerBlz().setValue((Object)AbstractTransferControl.this.gegenkonto.getBlz());
                new KontonummerListener().handleEvent(null);
                AbstractTransferControl.this.getStoreEmpfaenger().setValue((Object)Boolean.FALSE);
                try {
                    String zweck = (String)AbstractTransferControl.this.getZweck().getValue();
                    String zweck2 = AbstractTransferControl.this.getZweck2().getText();
                    if (zweck != null && zweck.length() > 0 || zweck2 != null && zweck2.length() > 0) {
                        return;
                    }
                    DBIterator list = AbstractTransferControl.this.getTransfer().getList();
                    list.addFilter("empfaenger_konto = ?", new Object[]{AbstractTransferControl.this.gegenkonto.getKontonummer()});
                    list.addFilter("empfaenger_blz = ?", new Object[]{AbstractTransferControl.this.gegenkonto.getBlz()});
                    list.setOrder("order by id desc");
                    if (list.hasNext()) {
                        HibiscusTransfer t = (HibiscusTransfer)list.next();
                        AbstractTransferControl.this.getZweck().setValue((Object)t.getZweck());
                        AbstractTransferControl.this.getZweck2().setText(t.getZweck2());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to autocomplete subject", (Throwable)e);
                }
            }
            catch (RemoteException er) {
                Logger.error((String)"error while choosing empfaenger", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei der Auswahl des Empf\u00e4ngers"));
            }
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = AbstractTransferControl.this.getKontoAuswahl().getValue();
                if (o == null || !(o instanceof Konto)) {
                    return;
                }
                AbstractTransferControl.this.getTransfer().setKonto(AbstractTransferControl.this.konto);
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating currency", (Throwable)er);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei Ermittlung der W\u00e4hrung"), 1));
            }
        }
    }

    private class KontonummerListener
    implements Listener {
        private KontonummerListener() {
        }

        public void handleEvent(Event event) {
            try {
                String kto = StringUtils.trimToNull((String)((String)AbstractTransferControl.this.getEmpfaengerKonto().getValue()));
                String blz = StringUtils.trimToNull((String)((String)AbstractTransferControl.this.getEmpfaengerBlz().getValue()));
                if (kto == null || blz == null) {
                    AbstractTransferControl.this.getEmpfaengerKonto().setComment("");
                    return;
                }
                AbstractTransferControl.this.getEmpfaengerKonto().setComment(i18n.tr(HBCIProperties.checkAccountCRC(blz, kto) ? "Konto OK" : "BLZ/Kto ung\u00fcltig, bitte pr\u00fcfen"));
            }
            catch (RemoteException er) {
                Logger.error((String)"error while checking konto/blz", (Throwable)er);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Pr\u00fcfen der Bankverbindung"), 1));
            }
        }
    }
}

