/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.accounts.AccountProvider;
import de.willuhn.jameica.hbci.accounts.AccountService;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class AccountNewController
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private List<InfoPanel> providers = null;

    public AccountNewController(AbstractView view) {
        super(view);
    }

    public synchronized List<InfoPanel> getAccountProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        this.providers = new ArrayList<InfoPanel>();
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        AccountService service = (AccountService)bs.get(AccountService.class);
        List<AccountProvider> list = service.getProviders();
        for (final AccountProvider p : list) {
            InfoPanel panel = p.getInfo();
            Button button = new Button(i18n.tr("Bank-Zugang anlegen..."), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    Logger.info((String)("starting creation of new bank account. type: " + p.getName()));
                    p.create();
                }
            }, null, false, "go-next.png");
            panel.addButton(button);
            this.providers.add(panel);
        }
        return this.providers;
    }
}

