/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.HibiscusAddressUpdate;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.PurposeCodeInput;
import de.willuhn.jameica.hbci.gui.input.ReminderIntervalInput;
import de.willuhn.jameica.hbci.gui.input.StoreAddressInput;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.gui.input.ZweckInput;
import de.willuhn.jameica.hbci.gui.parts.AuslandsUeberweisungList;
import de.willuhn.jameica.hbci.reminder.ReminderUtil;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AuslandsUeberweisungControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private AuslandsUeberweisungList list = null;
    private AuslandsUeberweisung transfer = null;
    private KontoInput kontoAuswahl = null;
    private Input betrag = null;
    private ZweckInput zweck = null;
    private AddressInput empfName = null;
    private TextInput empfkto = null;
    private TextInput bic = null;
    private TextInput endToEndId = null;
    private TextInput pmtInfId = null;
    private PurposeCodeInput purposeCode = null;
    private TerminInput termin = null;
    private SelectInput typ = null;
    private ReminderIntervalInput interval = null;
    private CheckboxInput storeEmpfaenger = null;
    private HibiscusAddressUpdate aUpdate = new HibiscusAddressUpdate();
    private Listener terminListener = new TerminListener();

    public AuslandsUeberweisungControl(AbstractView view) {
        super(view);
    }

    public AuslandsUeberweisung getTransfer() throws RemoteException {
        if (this.transfer != null) {
            return this.transfer;
        }
        Object o = this.getCurrentObject();
        if (o instanceof AuslandsUeberweisung) {
            this.transfer = (AuslandsUeberweisung)o;
            return this.transfer;
        }
        this.transfer = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
        return this.transfer;
    }

    public AuslandsUeberweisungList getAuslandsUeberweisungListe() throws RemoteException {
        if (this.list == null) {
            this.list = new AuslandsUeberweisungList(new AuslandsUeberweisungNew());
        }
        return this.list;
    }

    public Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        KontoListener kl = new KontoListener();
        MyKontoFilter filter = new MyKontoFilter();
        this.kontoAuswahl = new KontoInput(this.getTransfer().getKonto(), filter);
        this.kontoAuswahl.setName(i18n.tr("Pers\u00f6nliches Konto"));
        this.kontoAuswahl.setRememberSelection("auftraege", false);
        this.kontoAuswahl.setMandatory(true);
        this.kontoAuswahl.addListener(kl);
        this.kontoAuswahl.setEnabled(!this.getTransfer().ausgefuehrt());
        kl.handleEvent(null);
        if (!filter.found) {
            this.kontoAuswahl.setComment(i18n.tr("Bitte tragen Sie IBAN/BIC in Ihrem Konto ein"));
        }
        return this.kontoAuswahl;
    }

    public AddressInput getEmpfaengerName() throws RemoteException {
        if (this.empfName != null) {
            return this.empfName;
        }
        this.empfName = new AddressInput(this.getTransfer().getGegenkontoName(), AddressFilter.FOREIGN);
        this.empfName.setMandatory(true);
        this.empfName.addListener(new EmpfaengerListener());
        this.empfName.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.empfName;
    }

    public TextInput getEmpfaengerKonto() throws RemoteException {
        if (this.empfkto != null) {
            return this.empfkto;
        }
        this.empfkto = new IBANInput(this.getTransfer().getGegenkontoNummer(), this.getEmpfaengerBic());
        this.empfkto.setMandatory(true);
        this.empfkto.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.empfkto;
    }

    public Input getEmpfaengerBic() throws RemoteException {
        if (this.bic == null) {
            this.bic = new BICInput(this.getTransfer().getGegenkontoBLZ());
            this.bic.setEnabled(!this.getTransfer().ausgefuehrt());
        }
        return this.bic;
    }

    public Input getEndToEndId() throws RemoteException {
        if (this.endToEndId == null) {
            this.endToEndId = new TextInput(this.getTransfer().getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            this.endToEndId.setName(i18n.tr("End-to-End ID"));
            this.endToEndId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
            this.endToEndId.setEnabled(!this.getTransfer().ausgefuehrt());
            this.endToEndId.setHint(i18n.tr("freilassen wenn nicht ben\u00f6tigt"));
            this.endToEndId.setMandatory(false);
        }
        return this.endToEndId;
    }

    public Input getPmtInfId() throws RemoteException {
        if (this.pmtInfId != null) {
            return this.pmtInfId;
        }
        this.pmtInfId = new TextInput(this.getTransfer().getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
        this.pmtInfId.setName(i18n.tr("Referenz (Payment-Information ID)"));
        this.pmtInfId.setValidChars(HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
        this.pmtInfId.setEnabled(!this.getTransfer().ausgefuehrt());
        this.pmtInfId.setHint(i18n.tr("freilassen wenn nicht ben\u00f6tigt"));
        this.pmtInfId.setMandatory(false);
        return this.pmtInfId;
    }

    public Input getPurposeCode() throws RemoteException {
        if (this.purposeCode != null) {
            return this.purposeCode;
        }
        this.purposeCode = new PurposeCodeInput(this.getTransfer().getPurposeCode());
        this.purposeCode.setEnabled(!this.getTransfer().ausgefuehrt());
        this.purposeCode.setMandatory(false);
        return this.purposeCode;
    }

    public Input getZweck() throws RemoteException {
        if (this.zweck != null) {
            return this.zweck;
        }
        this.zweck = new ZweckInput(this.getTransfer().getZweck());
        this.zweck.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.zweck;
    }

    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        AuslandsUeberweisung t = this.getTransfer();
        double d = t.getBetrag();
        if (d == 0.0) {
            d = Double.NaN;
        }
        this.betrag = new DecimalInput(d, HBCI.DECIMALFORMAT);
        Konto k = t.getKonto();
        this.betrag.setComment(k == null ? "" : k.getWaehrung());
        this.betrag.setMandatory(true);
        this.betrag.setEnabled(!this.getTransfer().ausgefuehrt());
        new KontoListener().handleEvent(null);
        return this.betrag;
    }

    public TerminInput getTermin() throws RemoteException {
        if (this.termin != null) {
            return this.termin;
        }
        this.termin = new TerminInput(this.getTransfer());
        this.termin.setName(String.valueOf(this.termin.getName()) + "  ");
        this.termin.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    if (!AuslandsUeberweisungControl.this.termin.hasChanged()) {
                        return;
                    }
                    Date date = (Date)AuslandsUeberweisungControl.this.termin.getValue();
                    if (date == null) {
                        return;
                    }
                    Typ typ = (Typ)((Object)AuslandsUeberweisungControl.this.getTyp().getValue());
                    if (typ == null || typ == Typ.TERMIN) {
                        return;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(DateUtil.startOfDay((Date)new Date()));
                    cal.add(5, 6);
                    if (DateUtil.startOfDay((Date)date).after(cal.getTime())) {
                        String q = i18n.tr("Soll der Auftrag als bankseitig gef\u00fchrte SEPA-Termin\u00fcberweisung ausgef\u00fchrt werden?");
                        if (Application.getCallback().askUser(q)) {
                            AuslandsUeberweisungControl.this.getTyp().setValue((Object)Typ.TERMIN);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to check for termueb", (Throwable)e);
                }
            }
        });
        return this.termin;
    }

    public ReminderIntervalInput getReminderInterval() throws Exception {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new ReminderIntervalInput(this.getTransfer(), (Date)this.getTermin().getValue());
        return this.interval;
    }

    public CheckboxInput getStoreEmpfaenger() throws RemoteException {
        if (this.storeEmpfaenger != null) {
            return this.storeEmpfaenger;
        }
        this.storeEmpfaenger = new StoreAddressInput(this.getTransfer());
        return this.storeEmpfaenger;
    }

    public SelectInput getTyp() throws RemoteException {
        if (this.typ != null) {
            return this.typ;
        }
        final AuslandsUeberweisung u = this.getTransfer();
        this.typ = new SelectInput((Object[])Typ.values(), (Object)Typ.determine(u));
        this.typ.setName(i18n.tr("Auftragstyp"));
        this.typ.setAttribute("description");
        this.typ.setEnabled(!u.ausgefuehrt());
        this.typ.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    Typ t = (Typ)((Object)AuslandsUeberweisungControl.this.getTyp().getValue());
                    u.setTerminUeberweisung(t != null && t == Typ.TERMIN);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to set flag", (Throwable)e);
                }
            }
        });
        this.typ.addListener(this.terminListener);
        this.terminListener.handleEvent(null);
        return this.typ;
    }

    public synchronized boolean handleStore() {
        AuslandsUeberweisung t;
        block11: {
            t = null;
            try {
                t = this.getTransfer();
                if (!t.ausgefuehrt()) break block11;
                return true;
            }
            catch (Exception e) {
                if (t != null) {
                    try {
                        t.transactionRollback();
                    }
                    catch (Exception xe) {
                        Logger.error((String)"rollback failed", (Throwable)xe);
                    }
                }
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        t.transactionBegin();
        Double d = (Double)this.getBetrag().getValue();
        t.setBetrag(d == null ? Double.NaN : d);
        t.setKonto((Konto)this.getKontoAuswahl().getValue());
        t.setZweck((String)this.getZweck().getValue());
        t.setTermin((Date)this.getTermin().getValue());
        t.setEndtoEndId((String)this.getEndToEndId().getValue());
        t.setPmtInfId((String)this.getPmtInfId().getValue());
        t.setPurposeCode((String)this.getPurposeCode().getValue());
        Typ typ = (Typ)((Object)this.getTyp().getValue());
        if (typ != null) {
            typ.apply(t);
        }
        String kto = (String)this.getEmpfaengerKonto().getValue();
        String name = this.getEmpfaengerName().getText();
        String bic = (String)this.getEmpfaengerBic().getValue();
        t.setGegenkontoNummer(kto);
        t.setGegenkontoName(name);
        t.setGegenkontoBLZ(bic);
        t.store();
        ReminderIntervalInput input = this.getReminderInterval();
        if (input.containsInterval()) {
            ReminderUtil.apply(t, (ReminderInterval)input.getValue(), input.getEnd());
        }
        Boolean store = (Boolean)this.getStoreEmpfaenger().getValue();
        this.aUpdate.setCreate(store);
        HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
        e.setIban(kto);
        e.setName(name);
        e.setBic(bic);
        this.aUpdate.handleAction(e);
        GUI.getStatusBar().setSuccessText(i18n.tr("Auftrag gespeichert"));
        t.transactionCommit();
        if (t.getBetrag() > Settings.getUeberweisungLimit()) {
            GUI.getView().setErrorText(i18n.tr("Warnung: Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.getTransfer().getKonto().getWaehrung()));
        }
        return true;
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                return;
            }
            if (!(event.data instanceof Address)) {
                return;
            }
            Address a = (Address)event.data;
            AuslandsUeberweisungControl.this.aUpdate.setAddress(a);
            try {
                AuslandsUeberweisungControl.this.getEmpfaengerName().setText(a.getName());
                AuslandsUeberweisungControl.this.getEmpfaengerKonto().setValue((Object)a.getIban());
                AuslandsUeberweisungControl.this.getEmpfaengerBic().setValue((Object)a.getBic());
                AuslandsUeberweisungControl.this.getStoreEmpfaenger().setValue((Object)Boolean.FALSE);
                try {
                    String zweck = (String)AuslandsUeberweisungControl.this.getZweck().getValue();
                    if (zweck != null && zweck.length() > 0) {
                        return;
                    }
                    DBIterator list = AuslandsUeberweisungControl.this.getTransfer().getList();
                    list.addFilter("empfaenger_konto = ?", new Object[]{a.getIban()});
                    list.addFilter("empfaenger_name = ?", new Object[]{a.getName()});
                    list.setOrder("order by id desc");
                    if (list.hasNext()) {
                        HibiscusTransfer t = (HibiscusTransfer)list.next();
                        AuslandsUeberweisungControl.this.getZweck().setValue((Object)t.getZweck());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to autocomplete subject", (Throwable)e);
                }
            }
            catch (RemoteException er) {
                Logger.error((String)"error while choosing empfaenger", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei der Auswahl des Empf\u00e4ngers"));
            }
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = AuslandsUeberweisungControl.this.getKontoAuswahl().getValue();
                if (o == null || !(o instanceof Konto)) {
                    AuslandsUeberweisungControl.this.getBetrag().setComment("");
                    return;
                }
                Konto konto = (Konto)o;
                AuslandsUeberweisungControl.this.getBetrag().setComment(konto.getWaehrung());
                AuslandsUeberweisungControl.this.getTransfer().setKonto(konto);
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating currency", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei Ermittlung der W\u00e4hrung"));
            }
        }
    }

    private class MyKontoFilter
    extends KontoFilter {
        private KontoFilter foreign = KontoFilter.createForeign(SynchronizeJobSepaUeberweisung.class);
        private boolean found = false;

        private MyKontoFilter() {
        }

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            boolean b = this.foreign.accept(konto);
            this.found |= b;
            return b;
        }
    }

    private class TerminListener
    implements Listener {
        private TerminListener() {
        }

        public void handleEvent(Event event) {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TerminInput input = AuslandsUeberweisungControl.this.getTermin();
                        Typ typ = (Typ)((Object)AuslandsUeberweisungControl.this.getTyp().getValue());
                        if (typ != null && typ == Typ.TERMIN) {
                            input.setName(i18n.tr("Ausf\u00fchrungstermin"));
                            Date date = (Date)input.getValue();
                            if (date != null && !DateUtil.startOfDay((Date)date).after(DateUtil.startOfDay((Date)new Date()))) {
                                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Ausf\u00fchrungstermin der Termin\u00fcberweisung liegt in der Vergangenheit"), 2));
                            }
                        } else {
                            input.setName(i18n.tr("Erinnerungstermin"));
                        }
                        input.updateComment();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update label", (Throwable)e);
                    }
                }
            });
        }
    }

    public static enum Typ {
        UEBERWEISUNG("\u00dcberweisung"),
        TERMIN("Bankseitige SEPA-Termin\u00fcberweisung"),
        UMBUCHUNG("Interne Umbuchung (\u00dcbertrag)"),
        INSTANT("Echtzeit\u00fcberweisung (SEPA Instant-Payment)");

        private String description = null;

        private Typ(String description) {
            this.description = description;
        }

        public String getDescription() {
            return i18n.tr(this.description);
        }

        public static Typ determine(AuslandsUeberweisung u) throws RemoteException {
            if (u.isInstantPayment()) {
                return INSTANT;
            }
            if (u.isTerminUeberweisung()) {
                return TERMIN;
            }
            if (u.isUmbuchung()) {
                return UMBUCHUNG;
            }
            return UEBERWEISUNG;
        }

        public void apply(AuslandsUeberweisung u) throws RemoteException {
            u.setInstantPayment(this == INSTANT);
            u.setUmbuchung(this == UMBUCHUNG);
            u.setTerminUeberweisung(this == TERMIN);
        }
    }
}

