/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.TextSchluessel;
import de.willuhn.jameica.hbci.gui.action.DauerauftragNew;
import de.willuhn.jameica.hbci.gui.controller.AbstractTransferControl;
import de.willuhn.jameica.hbci.gui.dialogs.TurnusDialog;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.parts.DauerauftragList;
import de.willuhn.jameica.hbci.rmi.Dauerauftrag;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.TypedProperties;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DauerauftragControl
extends AbstractTransferControl {
    private Listener nextDate = new NextDateListener();
    private Input orderID = null;
    private DialogInput turnus = null;
    private DateInput ersteZahlung = null;
    private DateInput letzteZahlung = null;
    private SelectInput textschluessel = null;
    private TypedProperties bpd = null;
    private DauerauftragList list = null;

    public DauerauftragControl(AbstractView view) {
        super(view);
    }

    @Override
    public HibiscusTransfer getTransfer() throws RemoteException {
        return (Dauerauftrag)this.getCurrentObject();
    }

    private TypedProperties getBPD() throws RemoteException {
        if (this.bpd == null) {
            this.bpd = new TypedProperties();
        }
        return this.bpd;
    }

    public DauerauftragList getDauerauftragListe() throws RemoteException {
        if (this.list != null) {
            return this.list;
        }
        this.list = new DauerauftragList(new DauerauftragNew());
        return this.list;
    }

    public DialogInput getTurnus() throws RemoteException {
        if (this.turnus != null) {
            return this.turnus;
        }
        TurnusDialog td = new TurnusDialog(0);
        td.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (event == null || event.data == null) {
                    return;
                }
                Turnus choosen = (Turnus)event.data;
                try {
                    ((Dauerauftrag)DauerauftragControl.this.getTransfer()).setTurnus(choosen);
                    DauerauftragControl.this.getTurnus().setText(choosen.getBezeichnung());
                    DauerauftragControl.this.nextDate.handleEvent(null);
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while choosing turnus", (Throwable)e);
                    GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei der Auswahl des Zahlungsturnus"));
                }
            }
        });
        Dauerauftrag da = (Dauerauftrag)this.getTransfer();
        Turnus t = da.getTurnus();
        this.turnus = new DialogInput(t == null ? "" : t.getBezeichnung(), (AbstractDialog)td);
        this.turnus.setValue((Object)t);
        this.turnus.setMandatory(true);
        if (da.isActive()) {
            boolean changable = this.getBPD().getBoolean("turnuseditable", true) && this.getBPD().getBoolean("timeuniteditable", true);
            this.turnus.setEnabled(changable);
        }
        this.turnus.disableClientControl();
        return this.turnus;
    }

    public Input getOrderID() throws RemoteException {
        if (this.orderID != null) {
            return this.orderID;
        }
        this.orderID = new LabelInput(((Dauerauftrag)this.getTransfer()).getOrderID());
        return this.orderID;
    }

    public Input getErsteZahlung() throws RemoteException {
        if (this.ersteZahlung != null) {
            return this.ersteZahlung;
        }
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        Date d = t.getErsteZahlung();
        if (d == null) {
            d = new Date();
            t.setErsteZahlung(d);
        }
        this.ersteZahlung = new DateInput(d);
        this.ersteZahlung.setComment("");
        this.ersteZahlung.setTitle(i18n.tr("Datum der ersten Zahlung"));
        this.ersteZahlung.setText(i18n.tr("Bitte geben Sie das Datum der ersten Zahlung ein"));
        this.ersteZahlung.setMandatory(true);
        this.ersteZahlung.addListener(this.nextDate);
        if (t.isActive()) {
            this.ersteZahlung.setEnabled(this.getBPD().getBoolean("firstexeceditable", true));
        }
        this.nextDate.handleEvent(null);
        return this.ersteZahlung;
    }

    public Input getLetzteZahlung() throws RemoteException {
        if (this.letzteZahlung != null) {
            return this.letzteZahlung;
        }
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        Date d = t.getLetzteZahlung();
        this.letzteZahlung = new DateInput(d, HBCI.DATEFORMAT);
        this.letzteZahlung.setComment("");
        this.letzteZahlung.setTitle(i18n.tr("Datum der letzten Zahlung"));
        this.letzteZahlung.setText(i18n.tr("Bitte geben Sie das Datum der letzten Zahlung ein"));
        this.letzteZahlung.addListener(new Listener(){

            public void handleEvent(Event event) {
                DauerauftragControl.this.letzteZahlung.getValue();
            }
        });
        if (t.isActive()) {
            this.letzteZahlung.setEnabled(this.getBPD().getBoolean("lastexeceditable", true));
        }
        return this.letzteZahlung;
    }

    public Input getTextSchluessel() throws RemoteException {
        if (this.textschluessel != null) {
            return this.textschluessel;
        }
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        this.textschluessel = new SelectInput((Object[])TextSchluessel.get(TextSchluessel.SET_DAUER), (Object)TextSchluessel.get(t.getTextSchluessel()));
        if (t.isActive()) {
            this.textschluessel.setEnabled(this.getBPD().getBoolean("keyeditable", true));
        }
        return this.textschluessel;
    }

    @Override
    public KontoInput getKontoAuswahl() throws RemoteException {
        KontoInput i = super.getKontoAuswahl();
        i.setEnabled(!((Dauerauftrag)this.getTransfer()).isActive());
        return i;
    }

    @Override
    public Input getBetrag() throws RemoteException {
        Input i = super.getBetrag();
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        if (t.isActive()) {
            i.setEnabled(this.getBPD().getBoolean("valueeditable", true));
        }
        return i;
    }

    @Override
    public AddressInput getEmpfaengerName() throws RemoteException {
        AddressInput i = super.getEmpfaengerName();
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        if (t.isActive()) {
            boolean changable = this.getBPD().getBoolean("recnameeditable", true) && this.getBPD().getBoolean("recktoeditable", true);
            i.setEnabled(changable);
        }
        return i;
    }

    @Override
    public TextInput getEmpfaengerKonto() throws RemoteException {
        TextInput i = super.getEmpfaengerKonto();
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        if (t.isActive()) {
            i.setEnabled(this.getBPD().getBoolean("recktoeditable", true));
        }
        return i;
    }

    @Override
    public TextInput getEmpfaengerBlz() throws RemoteException {
        TextInput i = super.getEmpfaengerBlz();
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        if (t.isActive()) {
            i.setEnabled(this.getBPD().getBoolean("recktoeditable", true));
        }
        return i;
    }

    @Override
    public TextInput getZweck() throws RemoteException {
        TextInput i = super.getZweck();
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        if (t.isActive()) {
            i.setEnabled(this.getBPD().getBoolean("usageeditable", true));
        }
        return i;
    }

    @Override
    public DialogInput getZweck2() throws RemoteException {
        DialogInput i = super.getZweck2();
        Dauerauftrag t = (Dauerauftrag)this.getTransfer();
        if (t.isActive()) {
            i.setEnabled(this.getBPD().getBoolean("usageeditable", true));
        }
        return i;
    }

    @Override
    public synchronized boolean handleStore() {
        return true;
    }

    private class NextDateListener
    implements Listener {
        private NextDateListener() {
        }

        public void handleEvent(Event event) {
            try {
                Date first = (Date)DauerauftragControl.this.getErsteZahlung().getValue();
                Date last = (Date)DauerauftragControl.this.getLetzteZahlung().getValue();
                Turnus t = (Turnus)DauerauftragControl.this.getTurnus().getValue();
                if (first == null || t == null) {
                    return;
                }
                Date next = TurnusHelper.getNaechsteZahlung(first, last, t, first);
                if (next != null) {
                    DauerauftragControl.this.ersteZahlung.setComment(i18n.tr("N\u00e4chste: {0}", HBCI.DATEFORMAT.format(next)));
                } else {
                    DauerauftragControl.this.ersteZahlung.setComment("");
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to apply first payment date", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ermitteln der n\u00e4chsten Zahlung"), 1));
            }
        }
    }
}

