/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TreeFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.gui.parts.EinnahmenAusgabenVerlauf;
import de.willuhn.jameica.hbci.report.balance.AccountBalanceProvider;
import de.willuhn.jameica.hbci.report.balance.AccountBalanceService;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.EinnahmeAusgabe;
import de.willuhn.jameica.hbci.server.EinnahmeAusgabeTreeNode;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class EinnahmeAusgabeControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private KontoInput kontoAuswahl = null;
    private CheckboxInput onlyActive = null;
    private DateInput start = null;
    private DateInput end = null;
    private RangeInput range = null;
    private SelectInput interval = null;
    private List<EinnahmeAusgabeZeitraum> werte = null;
    private TreePart tree = null;
    private EinnahmenAusgabenVerlauf chart = null;

    public EinnahmeAusgabeControl(AbstractView view) {
        super(view);
    }

    public Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(null, KontoFilter.ALL);
        this.kontoAuswahl.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.kontoAuswahl.setSupportGroups(true);
        this.kontoAuswahl.setComment(null);
        this.kontoAuswahl.setRememberSelection("auswertungen.einnahmeausgabe");
        return this.kontoAuswahl;
    }

    public Input getStart() {
        if (this.start != null) {
            return this.start;
        }
        this.start = new DateFromInput(null, "auswertungen.einnahmeausgabe.filter.from");
        this.start.setName(i18n.tr("Von"));
        this.start.setComment(null);
        return this.start;
    }

    public CheckboxInput getActiveOnly() {
        if (this.onlyActive != null) {
            return this.onlyActive;
        }
        this.onlyActive = new CheckboxInput(settings.getBoolean("auswertungen.einnahmeausgabe.filter.active", false));
        this.onlyActive.setName(i18n.tr("Nur aktive Konten"));
        this.onlyActive.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("auswertungen.einnahmeausgabe.filter.active", ((Boolean)EinnahmeAusgabeControl.this.onlyActive.getValue()).booleanValue());
            }
        });
        return this.onlyActive;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        this.range = new RangeInput(this.getStart(), this.getEnd(), Range.Category.AUSWERTUNG, "auswertungen.einnahmeausgabe.filter.range");
        return this.range;
    }

    public Input getEnd() {
        if (this.end != null) {
            return this.end;
        }
        this.end = new DateToInput(null, "auswertungen.einnahmeausgabe.filter.to");
        this.end.setName(i18n.tr("bis"));
        this.end.setComment(null);
        return this.end;
    }

    public SelectInput getInterval() {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new SelectInput((Object[])Interval.values(), (Object)Interval.valueOf(settings.getString("auswertungen.einnahmeausgabe.filter.interval", "MONTH")));
        this.interval.setName(i18n.tr("Gruppierung nach"));
        this.interval.addListener(new Listener(){

            public void handleEvent(Event event) {
                Interval value = (Interval)((Object)EinnahmeAusgabeControl.this.interval.getValue());
                settings.setAttribute("auswertungen.einnahmeausgabe.filter.interval", value.name());
            }
        });
        return this.interval;
    }

    public EinnahmenAusgabenVerlauf getChart() throws RemoteException {
        if (this.chart != null) {
            return this.chart;
        }
        this.chart = new EinnahmenAusgabenVerlauf(this.getWerte());
        return this.chart;
    }

    public TreePart getTree() throws RemoteException {
        if (this.tree != null) {
            return this.tree;
        }
        this.tree = new TreePart(this.getWerte(), null);
        this.tree.addColumn(i18n.tr("Konto"), "text");
        this.tree.addColumn(i18n.tr("Anfangssaldo"), "anfangssaldo", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.tree.addColumn(i18n.tr("Einnahmen"), "einnahmen", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.tree.addColumn(i18n.tr("Ausgaben"), "ausgaben", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.tree.addColumn(i18n.tr("Endsaldo"), "endsaldo", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.tree.addColumn(i18n.tr("Plus/Minus"), "plusminus", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.tree.addColumn(i18n.tr("Differenz"), "differenz", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.tree.setFormatter(new TreeFormatter(){

            public void format(TreeItem item) {
                if (item == null || item.getData() instanceof EinnahmeAusgabeTreeNode) {
                    return;
                }
                EinnahmeAusgabe ea = (EinnahmeAusgabe)item.getData();
                boolean summe = ea.isSumme();
                try {
                    double plusminus = ea.getPlusminus();
                    if (summe) {
                        item.setForeground(Color.FOREGROUND.getSWTColor());
                    } else {
                        Konto k = ea.getKonto();
                        if (k != null && k.hasFlag(1)) {
                            item.setForeground(Color.COMMENT.getSWTColor());
                        } else {
                            item.setForeground(ColorUtil.getForeground(plusminus));
                        }
                        item.setFont(ea.hasDiff() && !summe ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to format line", (Throwable)e);
                }
            }
        });
        this.tree.setRememberColWidths(true);
        return this.tree;
    }

    private List<EinnahmeAusgabeZeitraum> getWerte() throws RemoteException {
        if (this.werte != null) {
            return this.werte;
        }
        java.util.Date start = (java.util.Date)this.getStart().getValue();
        java.util.Date end = (java.util.Date)this.getEnd().getValue();
        List<Konto> konten = this.getSelectedAccounts();
        List<Umsatz> umsatzList = this.getUmsaetze(konten, start, end);
        if (!umsatzList.isEmpty()) {
            if (start == null) {
                start = umsatzList.get(0).getDatum();
            }
            if (end == null) {
                end = umsatzList.get(umsatzList.size() - 1).getDatum();
            }
        }
        Map<String, List<Value>> saldenProKonto = this.getSaldenProKonto(konten, start, end);
        Interval interval = umsatzList.isEmpty() ? Interval.ALL : (Interval)((Object)this.getInterval().getValue());
        List<EinnahmeAusgabeTreeNode> nodes = this.createEmptyNodes(start, end, konten, interval);
        this.werte = new ArrayList<EinnahmeAusgabeZeitraum>();
        if (nodes.isEmpty()) {
            Logger.warn((String)("no nodes created between range starts on " + start + " and range ends on " + end));
            return this.werte;
        }
        this.addData(nodes, umsatzList, saldenProKonto, start, end);
        if (interval == Interval.ALL) {
            this.werte.addAll(this.getChildren(nodes.get(0)));
        } else {
            this.werte.addAll(nodes);
        }
        return this.werte;
    }

    private List<Umsatz> getUmsaetze(List<Konto> konten, java.util.Date start, java.util.Date end) throws RemoteException {
        DBIterator umsaetze = UmsatzUtil.getUmsaetze();
        if (start != null) {
            umsaetze.addFilter("datum >= ?", new Object[]{new Date(DateUtil.startOfDay((java.util.Date)start).getTime())});
        }
        if (end != null) {
            umsaetze.addFilter("datum <= ?", new Object[]{new Date(DateUtil.endOfDay((java.util.Date)end).getTime())});
        }
        if (konten != null && !konten.isEmpty()) {
            ArrayList<String> kontoIds = new ArrayList<String>();
            for (Konto konto : konten) {
                kontoIds.add(konto.getID());
            }
            umsaetze.addFilter("konto_id in (" + StringUtils.join(kontoIds, (String)",") + ")");
        }
        ArrayList<Umsatz> umsatzList = new ArrayList<Umsatz>();
        while (umsaetze.hasNext()) {
            Umsatz u = (Umsatz)umsaetze.next();
            if (u.hasFlag(2)) continue;
            umsatzList.add(u);
        }
        return umsatzList;
    }

    private Map<String, List<Value>> getSaldenProKonto(List<Konto> konten, java.util.Date start, java.util.Date end) throws RemoteException {
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        AccountBalanceService balanceService = (AccountBalanceService)bs.get(AccountBalanceService.class);
        HashMap<String, List<Value>> saldenProKonto = new HashMap<String, List<Value>>();
        if (start == null || end == null) {
            return saldenProKonto;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        cal.add(5, -1);
        java.util.Date saldoStart = cal.getTime();
        for (Konto konto : konten) {
            AccountBalanceProvider balanceProvider = balanceService.getBalanceProviderForAccount(konto);
            List<Value> balance = balanceProvider.getBalanceData(konto, saldoStart, end);
            saldenProKonto.put(konto.getID(), balance);
        }
        return saldenProKonto;
    }

    private void addData(List<EinnahmeAusgabeTreeNode> nodes, List<Umsatz> umsatzList, Map<String, List<Value>> saldoProKonto, java.util.Date start, java.util.Date end) throws RemoteException {
        int index = 0;
        EinnahmeAusgabeTreeNode currentNode = null;
        Map<String, EinnahmeAusgabe> kontoData = null;
        for (Umsatz umsatz : umsatzList) {
            while (currentNode == null || umsatz.getDatum().after(currentNode.getEnddatum())) {
                if (index >= nodes.size()) {
                    java.util.Date endInterval = currentNode != null ? currentNode.getEnddatum() : null;
                    Logger.warn((String)("found umsatz at date " + umsatz.getDatum() + " outside last interval ending at " + endInterval));
                    return;
                }
                currentNode = nodes.get(index++);
                kontoData = this.getKontoDataMap(currentNode);
            }
            EinnahmeAusgabe ea = (EinnahmeAusgabe)kontoData.get(umsatz.getKonto().getID());
            ea.addUmsatz(umsatz);
        }
        int tagStart = 0;
        for (EinnahmeAusgabeTreeNode node : nodes) {
            Map<String, EinnahmeAusgabe> kontoMap = this.getKontoDataMap(node);
            java.util.Date startDatum = start != null && tagStart == 0 ? start : node.getStartdatum();
            java.util.Date endDatum = end != null && end.before(node.getEnddatum()) ? end : node.getEnddatum();
            int tagEnde = tagStart + (int)this.getDifferenceDays(startDatum, endDatum) + 1;
            for (Map.Entry<String, EinnahmeAusgabe> kontoEntry : kontoMap.entrySet()) {
                EinnahmeAusgabe ea = kontoEntry.getValue();
                List<Value> saldo = saldoProKonto.get(ea.getKonto().getID());
                if (saldo == null || saldo.isEmpty()) continue;
                if (tagEnde >= saldo.size()) {
                    Logger.warn((String)("Unexpected access to saldo, should pick day at index " + tagEnde + " but saldo has only " + saldo.size() + " days. Using last available day instead"));
                    tagEnde = saldo.size() - 1;
                }
                ea.setAnfangssaldo(saldo.get(tagStart).getValue());
                ea.setEndsaldo(saldo.get(tagEnde).getValue());
            }
            tagStart = tagEnde;
        }
        this.calculateSums(nodes);
    }

    private Map<String, EinnahmeAusgabe> getKontoDataMap(EinnahmeAusgabeTreeNode node) throws RemoteException {
        HashMap<String, EinnahmeAusgabe> kontoData = new HashMap<String, EinnahmeAusgabe>();
        List<EinnahmeAusgabe> eaList = this.getChildren(node);
        for (EinnahmeAusgabe ea : eaList) {
            if (ea.getKonto() == null) continue;
            kontoData.put(ea.getKonto().getID(), ea);
        }
        return kontoData;
    }

    private void calculateSums(List<EinnahmeAusgabeTreeNode> nodes) throws RemoteException {
        for (EinnahmeAusgabeTreeNode node : nodes) {
            List<EinnahmeAusgabe> list = this.getChildren(node);
            double summeAnfangssaldo = 0.0;
            double summeEinnahmen = 0.0;
            double summeAusgaben = 0.0;
            double summeEndsaldo = 0.0;
            EinnahmeAusgabe sumElement = null;
            for (EinnahmeAusgabe ea : list) {
                if (!ea.isSumme()) {
                    summeAnfangssaldo += ea.getAnfangssaldo();
                    summeEinnahmen += ea.getEinnahmen();
                    summeAusgaben += ea.getAusgaben();
                    summeEndsaldo += ea.getEndsaldo();
                    continue;
                }
                if (sumElement != null) {
                    throw new IllegalStateException("implementation error - there must be only one sum element");
                }
                sumElement = ea;
            }
            if (sumElement == null) continue;
            sumElement.setAnfangssaldo(summeAnfangssaldo);
            sumElement.setEndsaldo(summeEndsaldo);
            sumElement.setEinnahmen(summeEinnahmen);
            sumElement.setAusgaben(summeAusgaben);
        }
    }

    private List<EinnahmeAusgabe> getChildren(EinnahmeAusgabeTreeNode treeNode) throws RemoteException {
        ArrayList<EinnahmeAusgabe> result = new ArrayList<EinnahmeAusgabe>();
        GenericIterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            result.add((EinnahmeAusgabe)iterator.next());
        }
        return result;
    }

    private List<Konto> getSelectedAccounts() throws RemoteException {
        ArrayList<Konto> result = new ArrayList<Konto>();
        Object o = this.getKontoAuswahl().getValue();
        if (o instanceof Konto) {
            result.add((Konto)o);
        } else if (o == null || o instanceof String) {
            boolean onlyActive = (Boolean)this.getActiveOnly().getValue();
            String group = o != null && o instanceof String ? (String)o : null;
            List<Konto> konten = KontoUtil.getKonten(onlyActive ? KontoFilter.ACTIVE : KontoFilter.ALL);
            for (Konto k : konten) {
                if (group != null && !Objects.equals(group, k.getKategorie())) continue;
                result.add(k);
            }
        }
        return result;
    }

    private List<EinnahmeAusgabeTreeNode> createEmptyNodes(java.util.Date start, java.util.Date end, List<Konto> konten, Interval interval) throws RemoteException {
        ArrayList<EinnahmeAusgabeTreeNode> result = new ArrayList<EinnahmeAusgabeTreeNode>();
        if (interval == Interval.ALL) {
            List<EinnahmeAusgabe> kontoNodes = this.getEmptyNodes(start, end, konten);
            EinnahmeAusgabeTreeNode node = new EinnahmeAusgabeTreeNode(start, end, kontoNodes);
            result.add(node);
        } else {
            if (start == null || end == null) {
                throw new IllegalStateException("programming error - if there is grouping, there must be transactions and hence both dates are set");
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtil.startOfDay((java.util.Date)start));
            while (!calendar.getTime().after(end)) {
                calendar.set(interval.type, 1);
                java.util.Date nodeFrom = calendar.getTime();
                calendar.add(interval.size, 1);
                calendar.add(14, -1);
                java.util.Date nodeTo = DateUtil.startOfDay((java.util.Date)calendar.getTime());
                List<EinnahmeAusgabe> werte = this.getEmptyNodes(nodeFrom, nodeTo, konten);
                result.add(new EinnahmeAusgabeTreeNode(nodeFrom, nodeTo, werte));
                calendar.setTime(nodeFrom);
                calendar.add(interval.size, 1);
            }
        }
        return result;
    }

    private List<EinnahmeAusgabe> getEmptyNodes(java.util.Date start, java.util.Date end, List<Konto> konten) throws RemoteException {
        ArrayList<EinnahmeAusgabe> result = new ArrayList<EinnahmeAusgabe>();
        for (Konto konto : konten) {
            EinnahmeAusgabe ea = new EinnahmeAusgabe(konto);
            ea.setStartdatum(start);
            ea.setEnddatum(end);
            result.add(ea);
        }
        if (konten.size() > 1) {
            EinnahmeAusgabe summe = new EinnahmeAusgabe();
            summe.setStartdatum(start);
            summe.setEnddatum(end);
            summe.setIsSumme(true);
            result.add(summe);
        }
        return result;
    }

    public void handleReload() {
        try {
            TreePart tree = this.getTree();
            tree.removeAll();
            this.werte = null;
            java.util.Date tStart = (java.util.Date)this.getStart().getValue();
            java.util.Date tEnd = (java.util.Date)this.getEnd().getValue();
            if (tStart != null && tEnd != null && tStart.after(tEnd)) {
                GUI.getView().setErrorText(i18n.tr("Das Anfangsdatum muss vor dem Enddatum liegen"));
                return;
            }
            tree.setList(this.getWerte());
            EinnahmenAusgabenVerlauf chart = this.getChart();
            chart.setList(this.getWerte());
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to redraw table", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren"), 1));
        }
    }

    private long getDifferenceDays(java.util.Date d1, java.util.Date d2) {
        LocalDate date1 = DateUtil.startOfDay((java.util.Date)this.toUtilDate(d1)).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate date2 = DateUtil.endOfDay((java.util.Date)this.toUtilDate(d2)).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return ChronoUnit.DAYS.between(date1, date2);
    }

    private java.util.Date toUtilDate(java.util.Date d) {
        if (d == null) {
            return new java.util.Date();
        }
        if (!(d instanceof Date)) {
            return d;
        }
        Date sql = (Date)d;
        return new java.util.Date(sql.getTime());
    }

    private static enum Interval {
        ALL(-1, -1, i18n.tr("Gesamtzeitraum")),
        YEAR(6, 1, i18n.tr("Jahr")),
        MONTH(5, 2, i18n.tr("Monat"));

        private String name;
        private int type;
        private int size;

        private Interval(int type, int size, String name) {
            this.name = name;
            this.type = type;
            this.size = size;
        }

        public String toString() {
            return this.name;
        }
    }
}

