/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.jost_net.OBanToo.SEPA.BankenDaten.Bank;
import de.jost_net.OBanToo.SEPA.BankenDaten.Banken;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Land.SEPALand;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerNew;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetail;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.parts.EmpfaengerList;
import de.willuhn.jameica.hbci.gui.parts.SimpleSepaLastschriftList;
import de.willuhn.jameica.hbci.gui.parts.SimpleSepaSammelLastBuchungList;
import de.willuhn.jameica.hbci.gui.parts.SimpleSepaSammelUeberweisungBuchungList;
import de.willuhn.jameica.hbci.gui.parts.SimpleSepaUeberweisungList;
import de.willuhn.jameica.hbci.gui.parts.UmsatzList;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisungBuchung;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.manager.HBCIUtils;

public class EmpfaengerControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Address address = null;
    private TextInput kontonummer = null;
    private TextInput blz = null;
    private Input name = null;
    private TextInput bic = null;
    private TextInput iban = null;
    private TextInput bank = null;
    private SelectInput kategorie = null;
    private Input kommentar = null;
    private Part list = null;
    private Part uebList = null;
    private Part lastList = null;
    private TablePart sammelUebList = null;
    private TablePart sammelLastList = null;
    private Part umsatzList = null;
    private IbanListener ibanListener = new IbanListener();

    public EmpfaengerControl(AbstractView view) {
        super(view);
    }

    public Address getAddress() throws RemoteException {
        if (this.address != null) {
            return this.address;
        }
        this.address = (Address)this.getCurrentObject();
        if (this.address != null) {
            return this.address;
        }
        this.address = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
        return this.address;
    }

    public boolean isHibiscusAdresse() throws RemoteException {
        Address a = this.getAddress();
        return a instanceof HibiscusAddress;
    }

    public Part getEmpfaengerListe() throws RemoteException {
        if (this.list != null) {
            return this.list;
        }
        this.list = new EmpfaengerList(new EmpfaengerNew());
        return this.list;
    }

    public Part getUmsatzListe() throws RemoteException {
        if (this.umsatzList != null) {
            return this.umsatzList;
        }
        Address a = this.getAddress();
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        String iban = a.getIban();
        String konto = a.getKontonummer();
        if (StringUtils.isNotEmpty((String)iban)) {
            if (StringUtils.isNotEmpty((String)konto)) {
                list.addFilter("((empfaenger_konto like ? and empfaenger_blz = ?) or lower(empfaenger_konto) = ?)", new Object[]{"%" + konto, a.getBlz(), iban.toLowerCase()});
            } else {
                list.addFilter("lower(empfaenger_konto) = ?", new Object[]{iban.toLowerCase()});
            }
        } else {
            list.addFilter("empfaenger_konto like ?", new Object[]{"%" + konto});
            list.addFilter("empfaenger_blz = ?", new Object[]{a.getBlz()});
        }
        this.umsatzList = new UmsatzList((GenericIterator<Umsatz>)list, (Action)new UmsatzDetail());
        return this.umsatzList;
    }

    public Part getUeberweisungListe() throws RemoteException {
        if (this.uebList != null) {
            return this.uebList;
        }
        DBIterator list = Settings.getDBService().createList(AuslandsUeberweisung.class);
        list.addFilter("empfaenger_konto = ?", new Object[]{this.getAddress().getIban()});
        list.setOrder(" ORDER BY id DESC");
        this.uebList = new SimpleSepaUeberweisungList((GenericIterator)list);
        return this.uebList;
    }

    public Part getLastschriftListe() throws RemoteException {
        if (this.lastList != null) {
            return this.lastList;
        }
        DBIterator list = Settings.getDBService().createList(SepaLastschrift.class);
        list.addFilter("empfaenger_konto = ?", new Object[]{this.getAddress().getIban()});
        list.setOrder(" ORDER BY id DESC");
        this.lastList = new SimpleSepaLastschriftList((GenericIterator)list);
        return this.lastList;
    }

    public Part getSammelUeberweisungListe() throws RemoteException {
        if (this.sammelUebList != null) {
            return this.sammelUebList;
        }
        DBIterator list = Settings.getDBService().createList(SepaSammelUeberweisungBuchung.class);
        list.addFilter("empfaenger_konto = ?", new Object[]{this.getAddress().getIban()});
        list.setOrder(" ORDER BY id DESC");
        this.sammelUebList = new SimpleSepaSammelUeberweisungBuchungList(PseudoIterator.asList((GenericIterator)list));
        return this.sammelUebList;
    }

    public Part getSammelLastListe() throws RemoteException {
        if (this.sammelLastList != null) {
            return this.sammelLastList;
        }
        DBIterator list = Settings.getDBService().createList(SepaSammelLastBuchung.class);
        list.addFilter("empfaenger_konto = ?", new Object[]{this.getAddress().getIban()});
        list.setOrder(" ORDER BY id DESC");
        this.sammelLastList = new SimpleSepaSammelLastBuchungList(PseudoIterator.asList((GenericIterator)list));
        return this.sammelLastList;
    }

    public Input getKontonummer() throws RemoteException {
        if (this.kontonummer != null) {
            return this.kontonummer;
        }
        this.kontonummer = new TextInput(this.getAddress().getKontonummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
        this.kontonummer.setValidChars(HBCIProperties.HBCI_KTO_VALIDCHARS);
        boolean b = this.isHibiscusAdresse();
        this.kontonummer.setEnabled(b);
        if (b) {
            this.kontonummer.addListener((Listener)this.ibanListener);
        }
        return this.kontonummer;
    }

    public Input getKommentar() throws RemoteException {
        if (this.kommentar != null) {
            return this.kommentar;
        }
        this.kommentar = new TextAreaInput(this.getAddress().getKommentar());
        this.kommentar.setEnabled(this.isHibiscusAdresse());
        return this.kommentar;
    }

    public SelectInput getKategorie() throws RemoteException {
        if (this.kategorie != null) {
            return this.kategorie;
        }
        List list = (List)Settings.getDBService().execute("select kategorie from empfaenger where kategorie is not null and kategorie != '' group by kategorie order by LOWER(kategorie)", null, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                ArrayList<String> list = new ArrayList<String>();
                list.add("");
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            }
        });
        this.kategorie = new SelectInput(list, (Object)this.getAddress().getKategorie());
        this.kategorie.setName(i18n.tr("Gruppe"));
        this.kategorie.setEditable(true);
        this.kategorie.setEnabled(this.isHibiscusAdresse());
        return this.kategorie;
    }

    public Input getBlz() throws RemoteException {
        if (this.blz != null) {
            return this.blz;
        }
        this.blz = new BLZInput(this.getAddress().getBlz());
        boolean b = this.isHibiscusAdresse();
        this.blz.setEnabled(b);
        if (b) {
            this.blz.addListener((Listener)this.ibanListener);
        }
        return this.blz;
    }

    public Input getIban() throws RemoteException {
        if (this.iban != null) {
            return this.iban;
        }
        boolean enabled = this.isHibiscusAdresse();
        this.iban = new IBANInput(this.getAddress().getIban(), this.getBic());
        this.iban.setEnabled(enabled);
        if (enabled) {
            this.iban.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        boolean haveBlz;
                        String iban = (String)EmpfaengerControl.this.getIban().getValue();
                        boolean haveIban = StringUtils.trimToNull((String)iban) != null;
                        boolean haveKto = StringUtils.trimToNull((String)((String)EmpfaengerControl.this.getKontonummer().getValue())) != null;
                        boolean bl = haveBlz = StringUtils.trimToNull((String)((String)EmpfaengerControl.this.getBlz().getValue())) != null;
                        if (!(!haveIban || haveKto && haveBlz)) {
                            IBAN i = new IBAN(iban);
                            SEPALand land = i.getLand();
                            if (land == null || !Objects.equals(land.getKennzeichen(), "DE")) {
                                Logger.info((String)"no auto completion of national account information for this country");
                                return;
                            }
                            if (!haveKto) {
                                EmpfaengerControl.this.getKontonummer().setValue((Object)i.getKonto());
                            }
                            if (!haveBlz) {
                                EmpfaengerControl.this.getBlz().setValue((Object)i.getBLZ());
                            }
                        }
                    }
                    catch (SEPAException se) {
                        Logger.debug((String)se.getMessage());
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to auto-complete account number", (Throwable)e);
                    }
                }
            });
        }
        return this.iban;
    }

    public Input getBic() throws RemoteException {
        if (this.bic != null) {
            return this.bic;
        }
        boolean enabled = this.isHibiscusAdresse();
        this.bic = new BICInput(this.getAddress().getBic());
        this.bic.setEnabled(enabled);
        if (enabled) {
            this.bic.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        String bic = (String)EmpfaengerControl.this.getBic().getValue();
                        String blz = (String)EmpfaengerControl.this.getBlz().getValue();
                        if (StringUtils.trimToNull((String)bic) != null && StringUtils.trimToNull((String)blz) == null) {
                            Bank bank = Banken.getBankByBIC((String)bic);
                            if (bank == null) {
                                Logger.info((String)("blz unknown for bic " + bic));
                                return;
                            }
                            EmpfaengerControl.this.getBlz().setValue((Object)bank.getBLZ());
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to auto-complete BLZ", (Throwable)e);
                    }
                }
            });
        }
        return this.bic;
    }

    public Input getBank() throws RemoteException {
        if (this.bank == null) {
            String s = null;
            Address a = this.getAddress();
            if (a instanceof HibiscusAddress) {
                s = ((HibiscusAddress)a).getBank();
            }
            this.bank = new TextInput(s, HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            this.bank.setEnabled(this.isHibiscusAdresse());
        }
        return this.bank;
    }

    public Input getName() throws RemoteException {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput(this.getAddress().getName(), HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
        this.name.setEnabled(this.isHibiscusAdresse());
        this.name.setMandatory(true);
        return this.name;
    }

    public synchronized void handleStore() {
        try {
            if (this.isHibiscusAdresse()) {
                HibiscusAddress a = (HibiscusAddress)this.getAddress();
                a.setKontonummer((String)this.getKontonummer().getValue());
                a.setBlz((String)this.getBlz().getValue());
                a.setName((String)this.getName().getValue());
                a.setKommentar((String)this.getKommentar().getValue());
                a.setKategorie((String)this.getKategorie().getValue());
                a.setBank((String)this.getBank().getValue());
                a.setIban((String)this.getIban().getValue());
                a.setBic((String)this.getBic().getValue());
                a.store();
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Adresse gespeichert"), 0));
            }
        }
        catch (ApplicationException e2) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e2.getMessage(), 1));
        }
        catch (RemoteException e) {
            Logger.error((String)"error while storing address", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Speichern der Adresse: {0}", e.getMessage()), 1));
        }
    }

    private class IbanListener
    implements Listener {
        private IbanListener() {
        }

        public void handleEvent(Event event) {
            try {
                String blz = StringUtils.trimToNull((String)((String)EmpfaengerControl.this.getBlz().getValue()));
                String bic = StringUtils.trimToNull((String)((String)EmpfaengerControl.this.getBic().getValue()));
                String kto = StringUtils.trimToNull((String)((String)EmpfaengerControl.this.getKontonummer().getValue()));
                String iban = StringUtils.trimToNull((String)((String)EmpfaengerControl.this.getIban().getValue()));
                if (blz != null && blz.length() == HBCIProperties.HBCI_BLZ_LENGTH) {
                    String newBic = null;
                    if (HBCI.COMPLETE_IBAN && kto != null && iban == null) {
                        IBAN newIban = HBCIProperties.getIBAN(blz, kto);
                        newBic = newIban.getBIC();
                        EmpfaengerControl.this.getIban().setValue((Object)newIban.getIBAN());
                    }
                    if (bic == null) {
                        if (newBic == null) {
                            newBic = HBCIUtils.getBICForBLZ((String)blz);
                        }
                        EmpfaengerControl.this.getBic().setValue((Object)newBic);
                    }
                }
            }
            catch (ApplicationException ae) {
                Logger.warn((String)("unable to complete IBAN/BIC: " + ae.getMessage()));
            }
            catch (Exception e) {
                Logger.error((String)"unable to auto-complete IBAN/BIC", (Throwable)e);
            }
        }
    }
}

