/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.jost_net.OBanToo.SEPA.BankenDaten.Bank;
import de.jost_net.OBanToo.SEPA.BankenDaten.Banken;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Land.SEPALand;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.KontoDelete;
import de.willuhn.jameica.hbci.gui.action.KontoNew;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetail;
import de.willuhn.jameica.hbci.gui.dialogs.SynchronizeOptionsDialog;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.BackendInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.input.KontoartInput;
import de.willuhn.jameica.hbci.gui.input.PassportInput;
import de.willuhn.jameica.hbci.gui.parts.KontoList;
import de.willuhn.jameica.hbci.gui.parts.ProtokollList;
import de.willuhn.jameica.hbci.gui.parts.SaldoChart;
import de.willuhn.jameica.hbci.gui.parts.UmsatzList;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.manager.HBCIUtils;

public class KontoControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Konto konto = null;
    private TextInput kontonummer = null;
    private TextInput unterkonto = null;
    private TextInput blz = null;
    private Input name = null;
    private Input bezeichnung = null;
    private Input backendAuswahl = null;
    private PassportInput passportAuswahl = null;
    private Input kundennummer = null;
    private Input kommentar = null;
    private Input accountType = null;
    private TextInput bic = null;
    private TextInput iban = null;
    private DecimalInput saldo = null;
    private DecimalInput avail = null;
    private SaldoMessageConsumer consumer = null;
    private Button synchronizeOptions = null;
    private Button protoButton = null;
    private Button delButton = null;
    private TablePart kontoList = null;
    private TablePart protokoll = null;
    private UmsatzList umsatzList = null;
    private SaldoChart saldoChart = null;
    private CheckboxInput offline = null;
    private SelectInput kategorie = null;
    private IbanListener ibanListener = new IbanListener();

    public KontoControl(AbstractView view) {
        super(view);
    }

    public Konto getKonto() throws RemoteException {
        if (this.konto != null) {
            return this.konto;
        }
        try {
            this.konto = (Konto)this.getCurrentObject();
            if (this.konto != null) {
                if (!this.konto.isNewObject()) {
                    this.konto = (Konto)Settings.getDBService().createObject(Konto.class, this.konto.getID());
                }
                return this.konto;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.konto = (Konto)Settings.getDBService().createObject(Konto.class, null);
        return this.konto;
    }

    public Part getProtokoll() throws RemoteException {
        if (this.protokoll != null) {
            return this.protokoll;
        }
        this.protokoll = new ProtokollList(this.getKonto(), null);
        return this.protokoll;
    }

    public Part getUmsatzList() throws RemoteException {
        if (this.umsatzList != null) {
            return this.umsatzList;
        }
        this.umsatzList = new UmsatzList(this.getKonto(), (Action)new UmsatzDetail());
        return this.umsatzList;
    }

    public Part getSaldoChart() throws RemoteException {
        if (this.saldoChart != null) {
            return this.saldoChart;
        }
        this.saldoChart = new SaldoChart(this.getKonto());
        this.saldoChart.setTinyView(true);
        return this.saldoChart;
    }

    public Input getKontonummer() throws RemoteException {
        if (this.kontonummer != null) {
            return this.kontonummer;
        }
        this.kontonummer = new TextInput(this.getKonto().getKontonummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
        this.kontonummer.setValidChars(HBCIProperties.HBCI_KTO_VALIDCHARS);
        this.kontonummer.setMandatory(true);
        this.kontonummer.addListener((Listener)this.ibanListener);
        this.ibanListener.handleEvent(null);
        return this.kontonummer;
    }

    public CheckboxInput getOffline() throws RemoteException {
        if (this.offline != null) {
            return this.offline;
        }
        this.offline = new CheckboxInput(this.getKonto().hasFlag(2));
        this.offline.setName(i18n.tr("Offline-Konto"));
        this.offline.addListener(new Listener(){

            public void handleEvent(Event event) {
                KontoControl.this.updateStatus();
            }
        });
        this.updateStatus();
        return this.offline;
    }

    public Input getUnterkonto() throws RemoteException {
        if (this.unterkonto != null) {
            return this.unterkonto;
        }
        this.unterkonto = new TextInput(this.getKonto().getUnterkonto(), HBCIProperties.HBCI_ID_MAXLENGTH);
        this.unterkonto.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        this.unterkonto.setComment(i18n.tr("Kann meist frei gelassen werden"));
        return this.unterkonto;
    }

    public Button getSynchronizeOptions() throws RemoteException {
        if (this.synchronizeOptions != null) {
            return this.synchronizeOptions;
        }
        this.synchronizeOptions = new Button(i18n.tr("Synchronisierungsoptionen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    SynchronizeOptionsDialog d = new SynchronizeOptionsDialog(KontoControl.this.getKonto(), 1);
                    d.open();
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)oce.getMessage());
                    return;
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to configure synchronize options", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Konfigurieren der Synchronisierungsoptionen: {0}", e.getMessage()), 1));
                }
            }
        }, (Object)this.getKonto(), false, "document-properties.png");
        this.synchronizeOptions.setEnabled(!this.getKonto().isNewObject() && !this.getKonto().hasFlag(1));
        return this.synchronizeOptions;
    }

    public Button getProtoButton() throws RemoteException {
        if (this.protoButton != null) {
            return this.protoButton;
        }
        this.protoButton = new Button(i18n.tr("Protokoll des Kontos"), (Action)new de.willuhn.jameica.hbci.gui.action.ProtokollList(), (Object)this.getKonto(), false, "dialog-information.png");
        this.protoButton.setEnabled(!this.getKonto().isNewObject());
        return this.protoButton;
    }

    public Button getDelButton() throws RemoteException {
        if (this.delButton != null) {
            return this.delButton;
        }
        this.delButton = new Button(i18n.tr("Konto l\u00f6schen"), (Action)new KontoDelete(), (Object)this.getKonto(), false, "user-trash-full.png");
        this.delButton.setEnabled(!this.getKonto().isNewObject());
        return this.delButton;
    }

    public Input getBlz() throws RemoteException {
        if (this.blz != null) {
            return this.blz;
        }
        this.blz = new BLZInput(this.getKonto().getBLZ());
        this.blz.setMandatory(true);
        this.blz.addListener((Listener)this.ibanListener);
        return this.blz;
    }

    public Input getName() throws RemoteException {
        if (this.name != null) {
            return this.name;
        }
        this.name = new TextInput(this.getKonto().getName(), HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
        this.name.setMandatory(true);
        return this.name;
    }

    public Input getBezeichnung() throws RemoteException {
        if (this.bezeichnung != null) {
            return this.bezeichnung;
        }
        this.bezeichnung = new TextInput(this.getKonto().getBezeichnung(), 255);
        return this.bezeichnung;
    }

    public Input getKundennummer() throws RemoteException {
        if (this.kundennummer != null) {
            return this.kundennummer;
        }
        this.kundennummer = new TextInput(this.getKonto().getKundennummer());
        this.kundennummer.setMandatory(true);
        return this.kundennummer;
    }

    public PassportInput getPassportAuswahl() throws RemoteException, ApplicationException {
        if (this.passportAuswahl != null) {
            return this.passportAuswahl;
        }
        this.passportAuswahl = new PassportInput(this.getKonto());
        return this.passportAuswahl;
    }

    public Input getBackendAuswahl() throws RemoteException, ApplicationException {
        if (this.backendAuswahl != null) {
            return this.backendAuswahl;
        }
        this.backendAuswahl = new BackendInput(this.getKonto());
        this.backendAuswahl.addListener(new Listener(){

            public void handleEvent(Event event) {
                KontoControl.this.updateStatus();
            }
        });
        this.updateStatus();
        return this.backendAuswahl;
    }

    public Input getAccountType() throws RemoteException {
        if (this.accountType != null) {
            return this.accountType;
        }
        this.accountType = new KontoartInput(this.getKonto().getAccountType());
        return this.accountType;
    }

    private void updateStatus() {
        try {
            boolean offline = (Boolean)this.getOffline().getValue();
            this.getSaldo().setEnabled(offline);
            this.applyOfflineState(offline);
            SynchronizeBackend backend = (SynchronizeBackend)this.getBackendAuswahl().getValue();
            this.getPassportAuswahl().setEnabled(!offline && backend != null);
            this.getPassportAuswahl().update(backend);
            this.getBackendAuswahl().setEnabled(!offline);
        }
        catch (Exception e) {
            Logger.error((String)"error while updating passport selection", (Throwable)e);
        }
    }

    public Input getSaldo() throws RemoteException {
        if (this.saldo != null) {
            return this.saldo;
        }
        this.saldo = new DecimalInput(this.getKonto().getSaldo(), HBCI.DECIMALFORMAT);
        this.saldo.setComment("");
        this.saldo.setEnabled(this.getKonto().hasFlag(2));
        this.consumer = new SaldoMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer((MessageConsumer)this.consumer);
        try {
            this.consumer.handleMessage(null);
        }
        catch (Exception e) {
            Logger.error((String)"unable to refresh saldo", (Throwable)e);
        }
        return this.saldo;
    }

    public Input getSaldoAvailable() throws RemoteException {
        if (this.avail != null) {
            return this.avail;
        }
        if (this.getKonto().hasFlag(2)) {
            return null;
        }
        double d = this.getKonto().getSaldoAvailable();
        if (Double.isNaN(d)) {
            return null;
        }
        this.avail = new DecimalInput(d, HBCI.DECIMALFORMAT);
        String w = this.getKonto().getWaehrung();
        if (w == null) {
            w = HBCIProperties.CURRENCY_DEFAULT_DE;
        }
        this.avail.setComment(w);
        this.avail.setEnabled(false);
        return this.avail;
    }

    public Input getKommentar() throws RemoteException {
        if (this.kommentar != null) {
            return this.kommentar;
        }
        this.kommentar = new TextAreaInput(this.getKonto().getKommentar());
        return this.kommentar;
    }

    public Input getIban() throws RemoteException {
        if (this.iban != null) {
            return this.iban;
        }
        this.iban = new IBANInput(this.getKonto().getIban(), this.getBic());
        this.iban.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    boolean haveBlz;
                    String iban = (String)KontoControl.this.getIban().getValue();
                    boolean haveIban = StringUtils.trimToNull((String)iban) != null;
                    boolean haveKto = StringUtils.trimToNull((String)((String)KontoControl.this.getKontonummer().getValue())) != null;
                    boolean bl = haveBlz = StringUtils.trimToNull((String)((String)KontoControl.this.getBlz().getValue())) != null;
                    if (!(!haveIban || haveKto && haveBlz)) {
                        IBAN i = new IBAN(iban);
                        SEPALand land = i.getLand();
                        if (land.getBankIdentifierLength() == null) {
                            Logger.info((String)"length of bank identifier unknown for this country");
                            return;
                        }
                        if (!haveKto) {
                            KontoControl.this.getKontonummer().setValue((Object)i.getKonto());
                        }
                        if (!haveBlz) {
                            KontoControl.this.getBlz().setValue((Object)i.getBLZ());
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to auto-complete account number", (Throwable)e);
                }
            }
        });
        return this.iban;
    }

    public Input getBic() throws RemoteException {
        if (this.bic != null) {
            return this.bic;
        }
        this.bic = new BICInput(this.getKonto().getBic());
        this.bic.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    String bic = (String)KontoControl.this.getBic().getValue();
                    String blz = (String)KontoControl.this.getBlz().getValue();
                    if (StringUtils.trimToNull((String)bic) != null && StringUtils.trimToNull((String)blz) == null) {
                        Bank bank = Banken.getBankByBIC((String)bic);
                        if (bank == null) {
                            Logger.info((String)("blz unknown for bic " + bic));
                            return;
                        }
                        KontoControl.this.getBlz().setValue((Object)bank.getBLZ());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to auto-complete BLZ", (Throwable)e);
                }
            }
        });
        return this.bic;
    }

    public SelectInput getKategorie() throws RemoteException {
        if (this.kategorie != null) {
            return this.kategorie;
        }
        LinkedList<String> groups = new LinkedList<String>();
        groups.add("");
        groups.addAll(KontoUtil.getGroups());
        this.kategorie = new SelectInput(groups, (Object)this.getKonto().getKategorie());
        this.kategorie.setName(i18n.tr("Gruppe"));
        this.kategorie.setEditable(true);
        return this.kategorie;
    }

    public MessageConsumer getSaldoMessageConsumer() {
        return this.consumer;
    }

    public TablePart getKontoListe() throws RemoteException {
        if (this.kontoList != null) {
            return this.kontoList;
        }
        this.kontoList = new KontoList(null, new KontoNew());
        this.kontoList.addColumn(i18n.tr("Ums\u00e4tze"), "numumsaetze");
        return this.kontoList;
    }

    public synchronized void handleStore() {
        try {
            boolean offline = (Boolean)this.getOffline().getValue();
            Konto k = this.getKonto();
            if (offline) {
                k.setBackendClass(null);
                k.setPassportClass(null);
                k.setSaldo((Double)this.getSaldo().getValue());
            } else {
                SynchronizeBackend backend = (SynchronizeBackend)this.getBackendAuswahl().getValue();
                k.setBackendClass(backend != null ? backend.getClass().getName() : null);
                BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                SynchronizeBackend hbci = (SynchronizeBackend)service.get(HBCISynchronizeBackend.class);
                Passport p = (Passport)this.getPassportAuswahl().getValue();
                if (backend != null && backend.equals(hbci) && p == null) {
                    throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Sicherheitsverfahren aus"));
                }
                k.setPassportClass(p != null ? p.getClass().getName() : null);
            }
            this.applyOfflineState(offline);
            k.setKontonummer((String)this.getKontonummer().getValue());
            k.setUnterkonto((String)this.getUnterkonto().getValue());
            k.setBLZ((String)this.getBlz().getValue());
            k.setName((String)this.getName().getValue());
            k.setBezeichnung((String)this.getBezeichnung().getValue());
            k.setKundennummer((String)this.getKundennummer().getValue());
            k.setKommentar((String)this.getKommentar().getValue());
            k.setIban((String)this.getIban().getValue());
            k.setBic((String)this.getBic().getValue());
            k.setKategorie((String)this.getKategorie().getValue());
            k.setAccountType((Integer)this.getAccountType().getValue());
            k.store();
            this.getProtoButton().setEnabled(true);
            this.getDelButton().setEnabled(true);
            this.getSynchronizeOptions().setEnabled(!k.hasFlag(1));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Konto gespeichert."), 0));
            Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)k));
            Application.getMessagingFactory().sendMessage((Message)new SaldoMessage((GenericObject)k));
        }
        catch (ApplicationException e1) {
            GUI.getView().setErrorText(i18n.tr(e1.getLocalizedMessage()));
        }
        catch (RemoteException e) {
            Logger.error((String)"unable to store konto", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Speichern des Kontos."));
        }
    }

    private void applyOfflineState(boolean offline) throws RemoteException {
        int flags = this.getKonto().getFlags();
        boolean have = this.getKonto().hasFlag(2);
        if (offline && !have) {
            this.getKonto().setFlags(flags | 2);
        } else if (!offline && have) {
            this.getKonto().setFlags(flags ^ 2);
        }
    }

    public void handleReload() {
        GUI.startSync((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    UmsatzList list = (UmsatzList)KontoControl.this.getUmsatzList();
                    list.removeAll();
                    Konto k = KontoControl.this.getKonto();
                    DBIterator i = k.getUmsaetze(HBCIProperties.UMSATZ_DEFAULT_DAYS);
                    while (i.hasNext()) {
                        list.addItem(i.next());
                    }
                    list.sort();
                    if (KontoControl.this.consumer != null) {
                        KontoControl.this.consumer.handleMessage(null);
                    }
                }
                catch (IllegalArgumentException iae) {
                    Logger.warn((String)"umsatz table has be disposed in the meantime, skip reload");
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"error while reloading umsatz list", (Throwable)e);
                }
            }
        });
    }

    private class IbanListener
    implements Listener {
        private IbanListener() {
        }

        public void handleEvent(Event event) {
            try {
                String blz = StringUtils.trimToNull((String)((String)KontoControl.this.getBlz().getValue()));
                String bic = StringUtils.trimToNull((String)((String)KontoControl.this.getBic().getValue()));
                String kto = StringUtils.trimToNull((String)((String)KontoControl.this.getKontonummer().getValue()));
                String iban = StringUtils.trimToNull((String)((String)KontoControl.this.getIban().getValue()));
                String txt = null;
                String newBic = null;
                if (blz != null && blz.length() == HBCIProperties.HBCI_BLZ_LENGTH) {
                    if (HBCI.COMPLETE_IBAN && kto != null && iban == null) {
                        IBAN newIban = HBCIProperties.getIBAN(blz, kto);
                        KontoControl.this.getIban().setValue((Object)newIban.getIBAN());
                        newBic = newIban.getBIC();
                        txt = i18n.tr("IBAN/BIC vervollst\u00e4ndigt. Zum \u00dcbernehmen \"Speichern\" dr\u00fccken.");
                    }
                    if (bic == null) {
                        if (newBic == null) {
                            newBic = HBCIUtils.getBICForBLZ((String)blz);
                        }
                        if (StringUtils.trimToNull(newBic) != null) {
                            KontoControl.this.getBic().setValue((Object)newBic);
                            txt = i18n.tr("BIC vervollst\u00e4ndigt. Zum \u00dcbernehmen \"Speichern\" dr\u00fccken.");
                        }
                    }
                }
                if (txt != null) {
                    GUI.getView().setSuccessText(txt);
                }
            }
            catch (ApplicationException ae) {
                Logger.warn((String)("unable to auto-complete IBAN/BIC: " + ae.getMessage()));
            }
            catch (Exception e) {
                Logger.error((String)"unable to auto-complete IBAN/BIC", (Throwable)e);
            }
        }
    }

    private class SaldoMessageConsumer
    implements MessageConsumer {
        private SaldoMessageConsumer() {
        }

        public boolean autoRegister() {
            return false;
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{SaldoMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Date d;
                        if (((SaldoMessageConsumer)SaldoMessageConsumer.this).KontoControl.this.saldo == null) {
                            return;
                        }
                        Konto k = KontoControl.this.getKonto();
                        double s = k.getSaldo();
                        ((SaldoMessageConsumer)SaldoMessageConsumer.this).KontoControl.this.saldo.setValue((Object)(Double.isNaN(s) ? null : Double.valueOf(s)));
                        double s2 = k.getSaldoAvailable();
                        if (KontoControl.this.getSaldoAvailable() != null) {
                            KontoControl.this.getSaldoAvailable().setValue((Object)(Double.isNaN(s2) ? null : Double.valueOf(s2)));
                        }
                        if ((d = k.getSaldoDatum()) == null) {
                            ((SaldoMessageConsumer)SaldoMessageConsumer.this).KontoControl.this.saldo.setComment(i18n.tr("noch kein Saldo ermittelt"));
                        } else {
                            ((SaldoMessageConsumer)SaldoMessageConsumer.this).KontoControl.this.saldo.setComment(i18n.tr("vom {0}", HBCI.LONGDATEFORMAT.format(d)));
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to refresh saldo", (Throwable)e);
                    }
                }
            });
        }
    }
}

