/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.FileInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.IntegerInput;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.parts.KontoauszugPdfList;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;

public class KontoauszugPdfControl
extends AbstractControl {
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(KontoauszugPdfControl.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Kontoauszug auszug = null;
    private KontoauszugPdfList list = null;
    private KontoInput konto = null;
    private Input datei = null;
    private Input abrufdatum = null;
    private TextAreaInput kommentar = null;
    private Input erstellungsdatum = null;
    private DateInput von = null;
    private DateInput bis = null;
    private Input jahr = null;
    private Input nummer = null;
    private Input name1 = null;
    private Input name2 = null;
    private Input name3 = null;
    private Input quittiertAm = null;

    public KontoauszugPdfControl(AbstractView view) {
        super(view);
    }

    private Kontoauszug getKontoauszug() throws RemoteException {
        if (this.auszug != null) {
            return this.auszug;
        }
        this.auszug = (Kontoauszug)this.getCurrentObject();
        if (this.auszug != null) {
            return this.auszug;
        }
        this.auszug = (Kontoauszug)Settings.getDBService().createObject(Kontoauszug.class, null);
        return this.auszug;
    }

    public KontoauszugPdfList getList() {
        if (this.list != null) {
            return this.list;
        }
        this.list = new KontoauszugPdfList();
        return this.list;
    }

    public KontoInput getKonto() throws RemoteException {
        if (this.konto != null) {
            return this.konto;
        }
        this.konto = new KontoInput(this.getKontoauszug().getKonto(), KontoFilter.ACTIVE);
        this.konto.setName(i18n.tr("Pers\u00f6nliches Konto"));
        this.konto.setRememberSelection("kontoauszug", false);
        this.konto.setMandatory(true);
        KontoListener l = new KontoListener();
        this.konto.addListener(l);
        l.handleEvent(null);
        return this.konto;
    }

    public Input getAbrufdatum() throws RemoteException {
        if (this.abrufdatum != null) {
            return this.abrufdatum;
        }
        this.abrufdatum = new DateInput(this.getKontoauszug().getAusfuehrungsdatum());
        this.abrufdatum.setName(i18n.tr("Abgerufen am"));
        this.abrufdatum.setEnabled(false);
        return this.abrufdatum;
    }

    public Input getErstellungsdatum() throws RemoteException {
        if (this.erstellungsdatum != null) {
            return this.erstellungsdatum;
        }
        Date erstellt = this.getKontoauszug().getErstellungsdatum();
        this.erstellungsdatum = new TextInput(erstellt != null ? HBCI.DATEFORMAT.format(erstellt) : "<" + i18n.tr("von der Bank nicht angegeben") + ">");
        this.erstellungsdatum.setName(i18n.tr("Erstellt am"));
        this.erstellungsdatum.setEnabled(false);
        return this.erstellungsdatum;
    }

    public Input getQuittierungsdatum() throws RemoteException {
        if (this.quittiertAm != null) {
            return this.quittiertAm;
        }
        this.quittiertAm = new DateInput(this.getKontoauszug().getQuittiertAm());
        this.quittiertAm.setName(i18n.tr("Empfang quittiert am"));
        this.quittiertAm.setEnabled(false);
        return this.quittiertAm;
    }

    public Input getVonDatum() throws RemoteException {
        if (this.von != null) {
            return this.von;
        }
        this.von = new DateInput(this.getKontoauszug().getVon());
        this.von.setTitle(i18n.tr("Startdatum"));
        this.von.setText(i18n.tr("Bitte w\u00e4hlen Sie das Startdatum des Zeitraumes aus."));
        this.von.setEnabled(true);
        return this.von;
    }

    public Input getBisDatum() throws RemoteException {
        if (this.bis != null) {
            return this.bis;
        }
        this.bis = new DateInput(this.getKontoauszug().getBis());
        this.bis.setName(i18n.tr("Bis"));
        this.bis.setTitle(i18n.tr("Enddatum"));
        this.bis.setText(i18n.tr("Bitte w\u00e4hlen Sie das Enddatum des Zeitraums aus."));
        this.bis.setEnabled(true);
        return this.bis;
    }

    public Input getJahr() throws RemoteException {
        if (this.jahr != null) {
            return this.jahr;
        }
        Integer i = this.getKontoauszug().getJahr();
        this.jahr = new IntegerInput(i != null ? i : -1);
        this.jahr.setName(i18n.tr("Jahr"));
        this.jahr.setEnabled(true);
        return this.jahr;
    }

    public Input getNummer() throws RemoteException {
        if (this.nummer != null) {
            return this.nummer;
        }
        Integer i = this.getKontoauszug().getNummer();
        this.nummer = new IntegerInput(i != null ? i : -1);
        this.nummer.setName(i18n.tr("Nummer"));
        this.nummer.setEnabled(true);
        return this.nummer;
    }

    public Input getName1() throws RemoteException {
        if (this.name1 != null) {
            return this.name1;
        }
        this.name1 = new TextInput(this.getKontoauszug().getName1(), 255);
        this.name1.setName(i18n.tr("Name 1"));
        return this.name1;
    }

    public Input getName2() throws RemoteException {
        if (this.name2 != null) {
            return this.name2;
        }
        this.name2 = new TextInput(this.getKontoauszug().getName2(), 255);
        this.name2.setName(i18n.tr("Name 2"));
        return this.name2;
    }

    public Input getName3() throws RemoteException {
        if (this.name3 != null) {
            return this.name3;
        }
        this.name3 = new TextInput(this.getKontoauszug().getName3(), 255);
        this.name3.setName(i18n.tr("Name 3"));
        return this.name3;
    }

    public TextAreaInput getKommentar() throws RemoteException {
        if (this.kommentar != null) {
            return this.kommentar;
        }
        this.kommentar = new TextAreaInput(this.getKontoauszug().getKommentar(), 1000);
        this.kommentar.setName(i18n.tr("Notizen"));
        return this.kommentar;
    }

    public Input getDatei() throws RemoteException {
        if (this.datei != null) {
            return this.datei;
        }
        Kontoauszug k = this.getKontoauszug();
        if (StringUtils.trimToNull((String)k.getUUID()) != null) {
            this.datei = new LabelInput(i18n.tr("In Archiv-Server gespeichert"));
        } else {
            String name = k.getDateiname();
            String path = k.getPfad();
            File f = name != null && path != null ? new File(path, name) : null;
            this.datei = new FileInput(f != null ? f.getAbsolutePath() : null, false){

                protected void customize(FileDialog fd) {
                    String dir = settings.getString(KontoauszugPdfControl.this.getLastdirKey(), settings.getString("lastdir", null));
                    if (dir != null) {
                        fd.setFilterPath(dir);
                    }
                    super.customize(fd);
                }
            };
            this.datei.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        String file = StringUtils.trimToNull((String)((String)KontoauszugPdfControl.this.getDatei().getValue()));
                        if (file != null) {
                            File f = new File(file);
                            String path = f.getParent();
                            settings.setAttribute(KontoauszugPdfControl.this.getLastdirKey(), path);
                        }
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"unable to determine last import dir", (Throwable)re);
                    }
                }
            });
        }
        this.datei.setName(i18n.tr("Datei"));
        return this.datei;
    }

    private String getLastdirKey() {
        String key = "lastdir";
        try {
            Konto k = (Konto)this.getKonto().getValue();
            if (k != null) {
                key = String.valueOf(key) + "." + k.getID();
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine current account", (Throwable)re);
        }
        return key;
    }

    public void handleOpen() throws ApplicationException {
        try {
            File f;
            String file = StringUtils.trimToNull((String)((String)this.getDatei().getValue()));
            File file2 = f = file != null ? new File(file) : KontoauszugPdfUtil.getFile(this.getKontoauszug());
            if (!f.exists() || !f.canRead()) {
                throw new ApplicationException(i18n.tr("Datei existiert nicht oder ist nicht lesbar"));
            }
            new Program().handleAction((Object)f);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to open file", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    public boolean handleStore() {
        try {
            Kontoauszug k = this.getKontoauszug();
            Konto konto = (Konto)this.getKonto().getValue();
            if (konto == null) {
                throw new ApplicationException("Bitte w\u00e4hlen Sie ein Konto aus.");
            }
            k.setKonto(konto);
            k.setBis((Date)this.getBisDatum().getValue());
            k.setVon((Date)this.getVonDatum().getValue());
            k.setJahr((Integer)this.getJahr().getValue());
            k.setKommentar((String)this.getKommentar().getValue());
            k.setName1((String)this.getName1().getValue());
            k.setName2((String)this.getName2().getValue());
            k.setName3((String)this.getName3().getValue());
            k.setNummer((Integer)this.getNummer().getValue());
            String file = StringUtils.trimToNull((String)((String)this.getDatei().getValue()));
            File f = file != null ? new File(file) : null;
            String name = f != null ? f.getName() : null;
            String path = f != null ? f.getParent() : null;
            k.setDateiname(name);
            k.setPfad(path);
            k.store();
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("\u00c4nderungen gespeichert."), 0));
            return true;
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"unable to save changes", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
        }
        return false;
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Input year = KontoauszugPdfControl.this.getJahr();
                Input nummer = KontoauszugPdfControl.this.getNummer();
                Object k = KontoauszugPdfControl.this.getKonto().getValue();
                if (k == null || !(k instanceof Konto)) {
                    return;
                }
                if (year.getValue() != null && nummer.getValue() != null) {
                    return;
                }
                Kontoauszug newest = KontoauszugPdfUtil.getNewestWithNumber((Konto)k);
                if (newest == null) {
                    return;
                }
                if (year.getValue() == null && newest.getJahr() != null) {
                    year.setValue((Object)newest.getJahr());
                }
                if (nummer.getValue() == null && newest.getNummer() != null) {
                    nummer.setValue((Object)(newest.getNummer() + 1));
                }
            }
            catch (Exception e) {
                Logger.error((String)"error while updating year/number", (Throwable)e);
            }
        }
    }
}

