/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.io.FileFinder;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.parts.FormTextPart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.InfoReader;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class LicenseControl
extends AbstractControl {
    private Part libList = null;
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public LicenseControl(AbstractView view) {
        super(view);
    }

    public Part getLibList() {
        if (this.libList != null) {
            return this.libList;
        }
        AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        Manifest manifest = null;
        try {
            manifest = Application.getPluginLoader().getManifest(HBCI.class);
        }
        catch (Exception e) {
            Logger.error((String)"unable to read info.xml from plugin hibiscus", (Throwable)e);
        }
        buffer.append("<p><span color=\"header\" font=\"header\">" + this.i18n.tr("Hibiscus") + "</span></p>");
        if (manifest != null) {
            buffer.append("<p>");
            buffer.append(manifest.getDescription());
            buffer.append("<br/>" + manifest.getHomepage());
            buffer.append("<br/>" + manifest.getLicense());
            buffer.append("</p>");
        }
        String path = plugin.getManifest().getPluginDir();
        FileFinder finder = new FileFinder(new File(String.valueOf(path) + "/lib"));
        finder.matches(".*?info\\.xml$");
        File[] fileArray = finder.findRecursive();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isFile() || !file.canRead()) {
                Logger.warn((String)("unable to read " + file + ", skipping"));
            } else {
                try {
                    InfoReader ir = new InfoReader((InputStream)new FileInputStream(file));
                    buffer.append("<p>");
                    buffer.append("<b>" + ir.getName() + "</b>");
                    buffer.append("<br/>" + ir.getDescription());
                    buffer.append("<br/>" + ir.getUrl());
                    buffer.append("<br/>" + ir.getLicense());
                    buffer.append("</p>");
                }
                catch (Exception e) {
                    Logger.error((String)("unable to parse " + file), (Throwable)e);
                }
            }
            ++n2;
        }
        buffer.append("</form>");
        this.libList = new FormTextPart(buffer.toString());
        return this.libList;
    }
}

