/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.TextSchluessel;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerAdd;
import de.willuhn.jameica.hbci.gui.action.SammelLastBuchungNew;
import de.willuhn.jameica.hbci.gui.controller.AbstractSammelTransferBuchungControl;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class SammelLastBuchungControl
extends AbstractSammelTransferBuchungControl {
    private SammelTransferBuchung buchung = null;
    private SelectInput textschluessel = null;
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public SammelLastBuchungControl(AbstractView view) {
        super(view);
    }

    @Override
    public SammelTransferBuchung getBuchung() {
        if (this.buchung != null) {
            return this.buchung;
        }
        this.buchung = (SammelLastBuchung)this.getCurrentObject();
        return this.buchung;
    }

    @Override
    public synchronized void handleStore(boolean next) {
        try {
            this.getBuchung().transactionBegin();
            Double db = (Double)this.getBetrag().getValue();
            this.getBuchung().setBetrag(db == null ? Double.NaN : db);
            this.getBuchung().setZweck((String)this.getZweck().getValue());
            this.getBuchung().setZweck2(this.getZweck2().getText());
            TextSchluessel ts = (TextSchluessel)this.getTextSchluessel().getValue();
            this.getBuchung().setTextSchluessel(ts == null ? null : ts.getCode());
            String kto = (String)this.getGegenKonto().getValue();
            String blz = (String)this.getGegenkontoBLZ().getValue();
            String name = this.getGegenkontoName().getText();
            this.getBuchung().setGegenkontoNummer(kto);
            this.getBuchung().setGegenkontoBLZ(blz);
            this.getBuchung().setGegenkontoName(name);
            String[] lines = (String[])this.zweckDialog.getData();
            if (lines != null) {
                this.getBuchung().setWeitereVerwendungszwecke(lines);
            }
            this.getBuchung().store();
            Boolean store = (Boolean)this.getStoreAddress().getValue();
            if (store.booleanValue()) {
                HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
                e.setBlz(blz);
                e.setKontonummer(kto);
                e.setName(name);
                new EmpfaengerAdd().handleAction(e);
            }
            GUI.getStatusBar().setSuccessText(this.i18n.tr("Buchung gespeichert"));
            this.getBuchung().transactionCommit();
            if (this.getBuchung().getBetrag() > Settings.getUeberweisungLimit()) {
                Konto k = this.getBuchung().getSammelTransfer().getKonto();
                String w = k != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE;
                GUI.getView().setErrorText(this.i18n.tr("Warnung: Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + w));
            }
            if (next) {
                new SammelLastBuchungNew().handleAction(this.getBuchung().getSammelTransfer());
            }
        }
        catch (ApplicationException e) {
            try {
                this.getBuchung().transactionRollback();
            }
            catch (RemoteException re) {
                Logger.error((String)"rollback failed", (Throwable)re);
            }
            GUI.getView().setErrorText(this.i18n.tr(e.getMessage()));
        }
        catch (Exception e2) {
            try {
                this.getBuchung().transactionRollback();
            }
            catch (RemoteException re) {
                Logger.error((String)"rollback failed", (Throwable)re);
            }
            Logger.error((String)"error while storing buchung", (Throwable)e2);
            GUI.getStatusBar().setErrorText(this.i18n.tr("Fehler beim Speichern der Buchung"));
        }
    }

    @Override
    public SelectInput getTextSchluessel() throws RemoteException {
        if (this.textschluessel != null) {
            return this.textschluessel;
        }
        this.textschluessel = new SelectInput((Object[])TextSchluessel.get(TextSchluessel.SET_SAMMELLAST), (Object)TextSchluessel.get(this.getBuchung().getTextSchluessel()));
        this.textschluessel.setEnabled(!this.getBuchung().getSammelTransfer().ausgefuehrt());
        return this.textschluessel;
    }
}

