/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.HibiscusAddressUpdate;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragExecute;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragNew;
import de.willuhn.jameica.hbci.gui.dialogs.TurnusDialog;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.PurposeCodeInput;
import de.willuhn.jameica.hbci.gui.input.StoreAddressInput;
import de.willuhn.jameica.hbci.gui.input.ZweckInput;
import de.willuhn.jameica.hbci.gui.parts.SepaDauerauftragList;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragStore;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.TypedProperties;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SepaDauerauftragControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Listener nextDate = new NextDateListener();
    private Input orderID = null;
    private DialogInput turnus = null;
    private DateInput ersteZahlung = null;
    private DateInput letzteZahlung = null;
    private KontoInput kontoAuswahl = null;
    private DecimalInput betrag = null;
    private ZweckInput zweck = null;
    private AddressInput empfName = null;
    private TextInput empfkto = null;
    private TextInput bic = null;
    private PurposeCodeInput purposeCode = null;
    private CheckboxInput storeEmpfaenger = null;
    private HibiscusAddressUpdate aUpdate = new HibiscusAddressUpdate();
    private SepaDauerauftrag transfer = null;
    private TypedProperties bpd = null;
    private SepaDauerauftragList list = null;

    public SepaDauerauftragControl(AbstractView view) {
        super(view);
    }

    public SepaDauerauftrag getTransfer() throws RemoteException {
        if (this.transfer != null) {
            return this.transfer;
        }
        Object o = this.getCurrentObject();
        if (o != null && o instanceof SepaDauerauftrag) {
            return (SepaDauerauftrag)o;
        }
        this.transfer = (SepaDauerauftrag)Settings.getDBService().createObject(SepaDauerauftrag.class, null);
        return this.transfer;
    }

    private TypedProperties getBPD() throws RemoteException {
        if (this.bpd != null) {
            return this.bpd;
        }
        SepaDauerauftrag auftrag = this.getTransfer();
        if (auftrag.isActive()) {
            BPDUtil.Support support = BPDUtil.getSupport(auftrag.getKonto(), BPDUtil.Query.DauerEdit);
            TypedProperties typedProperties = this.bpd = support != null ? support.getBpd() : null;
        }
        if (this.bpd == null) {
            this.bpd = new TypedProperties();
        }
        return this.bpd;
    }

    public SepaDauerauftragList getDauerauftragListe() throws RemoteException {
        if (this.list != null) {
            return this.list;
        }
        this.list = new SepaDauerauftragList(new SepaDauerauftragNew());
        return this.list;
    }

    public DialogInput getTurnus() throws RemoteException {
        if (this.turnus != null) {
            return this.turnus;
        }
        TurnusDialog td = new TurnusDialog(0);
        td.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (event == null || event.data == null) {
                    return;
                }
                Turnus choosen = (Turnus)event.data;
                try {
                    SepaDauerauftragControl.this.getTransfer().setTurnus(choosen);
                    SepaDauerauftragControl.this.getTurnus().setText(choosen.getBezeichnung());
                    SepaDauerauftragControl.this.nextDate.handleEvent(null);
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while choosing turnus", (Throwable)e);
                    GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei der Auswahl des Zahlungsturnus"));
                }
            }
        });
        SepaDauerauftrag da = this.getTransfer();
        Turnus t = da.getTurnus();
        this.turnus = new DialogInput(t == null ? "" : t.getBezeichnung(), (AbstractDialog)td);
        this.turnus.setValue((Object)t);
        this.turnus.setMandatory(true);
        if (da.isActive()) {
            boolean changable = this.getBPD().getBoolean("turnuseditable", true) && this.getBPD().getBoolean("timeuniteditable", true);
            this.turnus.setEnabled(changable);
        }
        this.turnus.disableClientControl();
        return this.turnus;
    }

    public Input getOrderID() throws RemoteException {
        if (this.orderID != null) {
            return this.orderID;
        }
        this.orderID = new LabelInput(this.getTransfer().getOrderID());
        return this.orderID;
    }

    public Input getErsteZahlung() throws RemoteException {
        if (this.ersteZahlung != null) {
            return this.ersteZahlung;
        }
        SepaDauerauftrag t = this.getTransfer();
        Date d = t.getErsteZahlung();
        if (d == null) {
            d = new Date();
            t.setErsteZahlung(d);
        }
        this.ersteZahlung = new DateInput(d);
        this.ersteZahlung.setComment("");
        this.ersteZahlung.setTitle(i18n.tr("Datum der ersten Zahlung"));
        this.ersteZahlung.setText(i18n.tr("Bitte geben Sie das Datum der ersten Zahlung ein"));
        this.ersteZahlung.setMandatory(true);
        this.ersteZahlung.addListener(this.nextDate);
        if (t.isActive()) {
            this.ersteZahlung.setEnabled(this.canEditErsteZahlung());
        }
        this.nextDate.handleEvent(null);
        return this.ersteZahlung;
    }

    private boolean canEditErsteZahlung() throws RemoteException {
        return this.getBPD().getBoolean("firstexeceditable", true);
    }

    public Input getLetzteZahlung() throws RemoteException {
        if (this.letzteZahlung != null) {
            return this.letzteZahlung;
        }
        SepaDauerauftrag t = this.getTransfer();
        Date d = t.getLetzteZahlung();
        this.letzteZahlung = new DateInput(d, HBCI.DATEFORMAT);
        this.letzteZahlung.setComment("");
        this.letzteZahlung.setTitle(i18n.tr("Datum der letzten Zahlung"));
        this.letzteZahlung.setText(i18n.tr("Bitte geben Sie das Datum der letzten Zahlung ein"));
        this.letzteZahlung.addListener(new Listener(){

            public void handleEvent(Event event) {
                SepaDauerauftragControl.this.letzteZahlung.getValue();
            }
        });
        if (t.isActive()) {
            this.letzteZahlung.setEnabled(this.getBPD().getBoolean("lastexeceditable", true));
        }
        return this.letzteZahlung;
    }

    public Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        KontoListener kl = new KontoListener();
        MyKontoFilter filter = new MyKontoFilter();
        this.kontoAuswahl = new KontoInput(this.getTransfer().getKonto(), filter);
        this.kontoAuswahl.setName(i18n.tr("Pers\u00f6nliches Konto"));
        this.kontoAuswahl.setRememberSelection("auftraege", false);
        this.kontoAuswahl.setMandatory(true);
        this.kontoAuswahl.addListener(kl);
        this.kontoAuswahl.setEnabled(!this.getTransfer().isActive());
        kl.handleEvent(null);
        if (!filter.found) {
            this.kontoAuswahl.setComment(i18n.tr("Bitte tragen Sie IBAN/BIC in Ihrem Konto ein"));
        }
        return this.kontoAuswahl;
    }

    public AddressInput getEmpfaengerName() throws RemoteException {
        if (this.empfName != null) {
            return this.empfName;
        }
        SepaDauerauftrag t = this.getTransfer();
        this.empfName = new AddressInput(t.getGegenkontoName(), AddressFilter.FOREIGN);
        this.empfName.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
        this.empfName.setMandatory(true);
        this.empfName.addListener(new EmpfaengerListener());
        if (t.isActive()) {
            boolean changable = this.getBPD().getBoolean("recnameeditable", true) && this.getBPD().getBoolean("recktoeditable", true);
            this.empfName.setEnabled(changable);
        }
        return this.empfName;
    }

    public TextInput getEmpfaengerKonto() throws RemoteException {
        if (this.empfkto != null) {
            return this.empfkto;
        }
        SepaDauerauftrag t = this.getTransfer();
        this.empfkto = new IBANInput(t.getGegenkontoNummer(), (Input)this.getEmpfaengerBic());
        this.empfkto.setMandatory(true);
        if (t.isActive()) {
            this.empfkto.setEnabled(this.getBPD().getBoolean("recktoeditable", true));
        }
        return this.empfkto;
    }

    public TextInput getEmpfaengerBic() throws RemoteException {
        if (this.bic != null) {
            return this.bic;
        }
        SepaDauerauftrag t = this.getTransfer();
        this.bic = new BICInput(t.getGegenkontoBLZ());
        if (t.isActive()) {
            this.bic.setEnabled(this.getBPD().getBoolean("recktoeditable", true));
        }
        return this.bic;
    }

    public CheckboxInput getStoreEmpfaenger() throws RemoteException {
        if (this.storeEmpfaenger != null) {
            return this.storeEmpfaenger;
        }
        this.storeEmpfaenger = new StoreAddressInput(this.getTransfer());
        return this.storeEmpfaenger;
    }

    public DecimalInput getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        SepaDauerauftrag t = this.getTransfer();
        double d = t.getBetrag();
        if (d == 0.0) {
            d = Double.NaN;
        }
        this.betrag = new DecimalInput(d, HBCI.DECIMALFORMAT);
        Konto k = t.getKonto();
        this.betrag.setComment(k == null ? "" : k.getWaehrung());
        this.betrag.setMandatory(true);
        if (t.isActive()) {
            this.betrag.setEnabled(this.getBPD().getBoolean("valueeditable", true));
        }
        new KontoListener().handleEvent(null);
        return this.betrag;
    }

    public Input getPurposeCode() throws RemoteException {
        if (this.purposeCode != null) {
            return this.purposeCode;
        }
        this.purposeCode = new PurposeCodeInput(this.getTransfer().getPurposeCode());
        this.purposeCode.setMandatory(false);
        return this.purposeCode;
    }

    public ZweckInput getZweck() throws RemoteException {
        if (this.zweck != null) {
            return this.zweck;
        }
        SepaDauerauftrag t = this.getTransfer();
        this.zweck = new ZweckInput(this.getTransfer().getZweck());
        this.zweck.setMandatory(true);
        if (t.isActive()) {
            this.zweck.setEnabled(this.getBPD().getBoolean("usageeditable", true));
        }
        return this.zweck;
    }

    public synchronized void handleExecute() {
        try {
            SepaDauerauftrag t = this.getTransfer();
            if (this.handleStore()) {
                if (t.isActive() && this.canEditErsteZahlung()) {
                    Date ersteZahlung = t.getErsteZahlung();
                    Date now = DateUtil.endOfDay((Date)new Date());
                    if (ersteZahlung == null || !ersteZahlung.after(now)) {
                        String msg = i18n.tr("Das Datum der ersten Zahlung befindet sich in der Vergangenheit.\nManche Banken verlangen auch bei der \u00c4nderung existierender Dauerauftr\u00e4ge\ndie Angabe eines zuk\u00fcnftigen Datums f\u00fcr die erste (n\u00e4chste) Zahlung.\n\nDer Auftrag k\u00f6nnte von der Bank eventuell abgelehnt werden.\n\nM\u00f6chten Sie den Vorgang dennoch fortsetzen?\nKlicken Sie alternativ auf \"Nein\" und \u00e4ndern Sie das Datum der ersten Zahlung.");
                        if (!Application.getCallback().askUser(msg)) {
                            return;
                        }
                    }
                }
                new SepaDauerauftragExecute().handleAction(t);
            }
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while executing order", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
        }
    }

    public synchronized boolean handleStore() {
        SepaDauerauftrag t = null;
        try {
            t = this.getTransfer();
            t.transactionBegin();
            Double d = (Double)this.getBetrag().getValue();
            t.setBetrag(d == null ? Double.NaN : d);
            t.setKonto((Konto)this.getKontoAuswahl().getValue());
            t.setErsteZahlung((Date)this.getErsteZahlung().getValue());
            t.setLetzteZahlung((Date)this.getLetzteZahlung().getValue());
            t.setTurnus((Turnus)this.getTurnus().getValue());
            t.setZweck((String)this.getZweck().getValue());
            t.setPurposeCode((String)this.getPurposeCode().getValue());
            String kto = (String)this.getEmpfaengerKonto().getValue();
            String name = this.getEmpfaengerName().getText();
            String bic = (String)this.getEmpfaengerBic().getValue();
            t.setGegenkontoNummer(kto);
            t.setGegenkontoName(name);
            t.setGegenkontoBLZ(bic);
            t.store();
            Boolean store = (Boolean)this.getStoreEmpfaenger().getValue();
            this.aUpdate.setCreate(store);
            HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
            e.setIban(kto);
            e.setName(name);
            e.setBic(bic);
            this.aUpdate.handleAction(e);
            GUI.getStatusBar().setSuccessText(i18n.tr("Auftrag gespeichert"));
            t.transactionCommit();
            if (t.getBetrag() > Settings.getUeberweisungLimit()) {
                GUI.getView().setErrorText(i18n.tr("Warnung: Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.getTransfer().getKonto().getWaehrung()));
            }
            return true;
        }
        catch (Exception e) {
            if (t != null) {
                try {
                    t.transactionRollback();
                }
                catch (Exception xe) {
                    Logger.error((String)"rollback failed", (Throwable)xe);
                }
            }
            if (e instanceof ApplicationException) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
            } else {
                Logger.error((String)"error while saving order", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
            }
            return false;
        }
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                return;
            }
            if (!(event.data instanceof Address)) {
                return;
            }
            Address a = (Address)event.data;
            SepaDauerauftragControl.this.aUpdate.setAddress(a);
            try {
                SepaDauerauftragControl.this.getEmpfaengerName().setText(a.getName());
                SepaDauerauftragControl.this.getEmpfaengerKonto().setValue((Object)a.getIban());
                SepaDauerauftragControl.this.getEmpfaengerBic().setValue((Object)a.getBic());
                SepaDauerauftragControl.this.getStoreEmpfaenger().setValue((Object)Boolean.FALSE);
                try {
                    String zweck = (String)SepaDauerauftragControl.this.getZweck().getValue();
                    if (zweck != null && zweck.length() > 0) {
                        return;
                    }
                    DBIterator list = SepaDauerauftragControl.this.getTransfer().getList();
                    list.addFilter("empfaenger_konto = ?", new Object[]{a.getIban()});
                    list.addFilter("empfaenger_name = ?", new Object[]{a.getName()});
                    list.setOrder("order by id desc");
                    if (list.hasNext()) {
                        HibiscusTransfer t = (HibiscusTransfer)list.next();
                        SepaDauerauftragControl.this.getZweck().setValue(t.getZweck());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to autocomplete subject", (Throwable)e);
                }
            }
            catch (RemoteException er) {
                Logger.error((String)"error while choosing empfaenger", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei der Auswahl des Empf\u00e4ngers"));
            }
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = SepaDauerauftragControl.this.getKontoAuswahl().getValue();
                if (o == null || !(o instanceof Konto)) {
                    SepaDauerauftragControl.this.getBetrag().setComment("");
                    return;
                }
                Konto konto = (Konto)o;
                SepaDauerauftragControl.this.getBetrag().setComment(konto.getWaehrung());
                SepaDauerauftragControl.this.getTransfer().setKonto(konto);
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating currency", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei Ermittlung der W\u00e4hrung"));
            }
        }
    }

    private class MyKontoFilter
    extends KontoFilter {
        private KontoFilter foreign = KontoFilter.createForeign(SynchronizeJobSepaDauerauftragStore.class);
        private boolean found = false;

        private MyKontoFilter() {
        }

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            boolean b = this.foreign.accept(konto);
            this.found |= b;
            return b;
        }
    }

    private class NextDateListener
    implements Listener {
        private NextDateListener() {
        }

        public void handleEvent(Event event) {
            try {
                Date first = (Date)SepaDauerauftragControl.this.getErsteZahlung().getValue();
                Date last = (Date)SepaDauerauftragControl.this.getLetzteZahlung().getValue();
                Turnus t = (Turnus)SepaDauerauftragControl.this.getTurnus().getValue();
                if (first == null || t == null) {
                    return;
                }
                Date next = TurnusHelper.getNaechsteZahlung(first, last, t, new Date());
                if (next != null) {
                    SepaDauerauftragControl.this.ersteZahlung.setComment(i18n.tr("N\u00e4chste: {0}", HBCI.DATEFORMAT.format(next)));
                } else {
                    SepaDauerauftragControl.this.ersteZahlung.setComment("");
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to apply first payment date", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ermitteln der n\u00e4chsten Zahlung"), 1));
            }
        }
    }
}

