/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.HibiscusAddressUpdate;
import de.willuhn.jameica.hbci.gui.action.SepaLastschriftNew;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.gui.input.BICInput;
import de.willuhn.jameica.hbci.gui.input.IBANInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.ReminderIntervalInput;
import de.willuhn.jameica.hbci.gui.input.StoreAddressInput;
import de.willuhn.jameica.hbci.gui.input.TerminInput;
import de.willuhn.jameica.hbci.gui.input.ZweckInput;
import de.willuhn.jameica.hbci.gui.parts.SepaLastschriftList;
import de.willuhn.jameica.hbci.reminder.ReminderUtil;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageBus;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SepaLastschriftControl
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private SepaLastschriftList list = null;
    private SepaLastschrift transfer = null;
    private KontoInput kontoAuswahl = null;
    private Input betrag = null;
    private ZweckInput zweck = null;
    private AddressInput empfName = null;
    private TextInput empfkto = null;
    private TextInput bic = null;
    private TextInput endToEndId = null;
    private TextInput pmtInfId = null;
    private TextInput creditorId = null;
    private TextInput mandateId = null;
    private DateInput signature = null;
    private SelectInput sequenceType = null;
    private SelectInput type = null;
    private DateInput targetDate = null;
    private TerminInput termin = null;
    private ReminderIntervalInput interval = null;
    private CheckboxInput storeEmpfaenger = null;
    private HibiscusAddressUpdate aUpdate = new HibiscusAddressUpdate();
    private HibiscusAddress address = null;

    public SepaLastschriftControl(AbstractView view) {
        super(view);
    }

    public SepaLastschrift getTransfer() throws RemoteException {
        if (this.transfer != null) {
            return this.transfer;
        }
        Object o = this.getCurrentObject();
        if (o instanceof SepaLastschrift) {
            this.transfer = (SepaLastschrift)o;
            return this.transfer;
        }
        this.transfer = (SepaLastschrift)Settings.getDBService().createObject(SepaLastschrift.class, null);
        return this.transfer;
    }

    public SepaLastschriftList getSepaLastschriftListe() throws RemoteException {
        if (this.list == null) {
            this.list = new SepaLastschriftList(new SepaLastschriftNew());
        }
        return this.list;
    }

    public Input getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        KontoListener kl = new KontoListener();
        MyKontoFilter filter = new MyKontoFilter();
        this.kontoAuswahl = new KontoInput(this.getTransfer().getKonto(), filter);
        this.kontoAuswahl.setName(i18n.tr("Pers\u00f6nliches Konto"));
        this.kontoAuswahl.setRememberSelection("auftraege", false);
        this.kontoAuswahl.setMandatory(true);
        this.kontoAuswahl.addListener(kl);
        this.kontoAuswahl.setEnabled(!this.getTransfer().ausgefuehrt());
        kl.handleEvent(null);
        if (!filter.found) {
            this.kontoAuswahl.setComment(i18n.tr("Bitte tragen Sie IBAN/BIC in Ihrem Konto ein"));
        }
        return this.kontoAuswahl;
    }

    public AddressInput getEmpfaengerName() throws RemoteException {
        if (this.empfName != null) {
            return this.empfName;
        }
        try {
            String id;
            SepaLastschrift s = this.getTransfer();
            if (!s.isNewObject() && (id = StringUtils.trimToNull((String)MetaKey.ADDRESS_ID.get(s))) != null) {
                this.address = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, id);
            }
        }
        catch (ObjectNotFoundException s) {
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to restore linked address from transfer", (Throwable)re);
        }
        this.empfName = new AddressInput(this.getTransfer().getGegenkontoName(), AddressFilter.FOREIGN);
        this.empfName.setMandatory(true);
        this.empfName.addListener(new EmpfaengerListener());
        this.empfName.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.empfName;
    }

    public TextInput getEmpfaengerKonto() throws RemoteException {
        if (this.empfkto != null) {
            return this.empfkto;
        }
        this.empfkto = new IBANInput(this.getTransfer().getGegenkontoNummer(), this.getEmpfaengerBic());
        this.empfkto.setValidChars(HBCIProperties.HBCI_IBAN_VALIDCHARS);
        this.empfkto.setMandatory(true);
        this.empfkto.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.empfkto;
    }

    public Input getEmpfaengerBic() throws RemoteException {
        if (this.bic == null) {
            this.bic = new BICInput(this.getTransfer().getGegenkontoBLZ());
            this.bic.setEnabled(!this.getTransfer().ausgefuehrt());
        }
        return this.bic;
    }

    public Input getEndToEndId() throws RemoteException {
        if (this.endToEndId == null) {
            this.endToEndId = new TextInput(this.getTransfer().getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            this.endToEndId.setName(i18n.tr("End-to-End ID"));
            this.endToEndId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
            this.endToEndId.setEnabled(!this.getTransfer().ausgefuehrt());
            this.endToEndId.setHint(i18n.tr("freilassen wenn nicht ben\u00f6tigt"));
            this.endToEndId.setMandatory(false);
        }
        return this.endToEndId;
    }

    public Input getPmtInfId() throws RemoteException {
        if (this.pmtInfId != null) {
            return this.pmtInfId;
        }
        this.pmtInfId = new TextInput(this.getTransfer().getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
        this.pmtInfId.setName(i18n.tr("Referenz (Payment-Information ID)"));
        this.pmtInfId.setValidChars(HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
        this.pmtInfId.setEnabled(!this.getTransfer().ausgefuehrt());
        this.pmtInfId.setHint(i18n.tr("freilassen wenn nicht ben\u00f6tigt"));
        this.pmtInfId.setMandatory(false);
        return this.pmtInfId;
    }

    public Input getCreditorId() throws RemoteException {
        if (this.creditorId == null) {
            this.creditorId = new TextInput(this.getTransfer().getCreditorId(), HBCIProperties.HBCI_SEPA_CREDITORID_MAXLENGTH);
            this.creditorId.setName(i18n.tr("Gl\u00e4ubiger-Identifikation"));
            this.creditorId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
            this.creditorId.setEnabled(!this.getTransfer().ausgefuehrt());
            this.creditorId.setMandatory(true);
        }
        return this.creditorId;
    }

    public Input getMandateId() throws RemoteException {
        if (this.mandateId == null) {
            this.mandateId = new TextInput(this.getTransfer().getMandateId(), HBCIProperties.HBCI_SEPA_MANDATEID_MAXLENGTH);
            this.mandateId.setName(i18n.tr("Mandats-Referenz"));
            this.mandateId.setValidChars(HBCIProperties.HBCI_SEPA_MANDATE_VALIDCHARS);
            this.mandateId.setEnabled(!this.getTransfer().ausgefuehrt());
            this.mandateId.setMandatory(true);
        }
        return this.mandateId;
    }

    public Input getSignatureDate() throws RemoteException {
        if (this.signature == null) {
            this.signature = new DateInput(this.getTransfer().getSignatureDate(), DateUtil.DEFAULT_FORMAT);
            this.signature.setName(i18n.tr("Unterschriftsdatum des Mandats"));
            this.signature.setEnabled(!this.getTransfer().ausgefuehrt());
            this.signature.setMandatory(true);
        }
        return this.signature;
    }

    public Input getSequenceType() throws RemoteException {
        if (this.sequenceType == null) {
            this.sequenceType = new SelectInput((Object[])SepaLastSequenceType.values(), (Object)this.getTransfer().getSequenceType());
            this.sequenceType.setName(i18n.tr("Sequenz-Typ"));
            this.sequenceType.setEnabled(!this.getTransfer().ausgefuehrt());
            this.sequenceType.setMandatory(true);
        }
        return this.sequenceType;
    }

    public Input getType() throws RemoteException {
        if (this.type == null) {
            this.type = new SelectInput((Object[])SepaLastType.values(), (Object)this.getTransfer().getType());
            this.type.setName(i18n.tr("Lastschrift-Art"));
            this.type.setEnabled(!this.getTransfer().ausgefuehrt());
        }
        return this.type;
    }

    public Input getTargetDate() throws RemoteException {
        if (this.targetDate == null) {
            this.targetDate = new DateInput(this.getTransfer().getTargetDate(), DateUtil.DEFAULT_FORMAT);
            this.targetDate.setName(i18n.tr("Zieltermin"));
            this.targetDate.setEnabled(!this.getTransfer().ausgefuehrt());
            this.targetDate.setMandatory(true);
        }
        return this.targetDate;
    }

    public Input getZweck() throws RemoteException {
        if (this.zweck != null) {
            return this.zweck;
        }
        this.zweck = new ZweckInput(this.getTransfer().getZweck());
        this.zweck.setEnabled(!this.getTransfer().ausgefuehrt());
        return this.zweck;
    }

    public Input getBetrag() throws RemoteException {
        if (this.betrag != null) {
            return this.betrag;
        }
        SepaLastschrift t = this.getTransfer();
        double d = t.getBetrag();
        if (d == 0.0) {
            d = Double.NaN;
        }
        this.betrag = new DecimalInput(d, HBCI.DECIMALFORMAT);
        Konto k = t.getKonto();
        this.betrag.setComment(k == null ? "" : k.getWaehrung());
        this.betrag.setMandatory(true);
        this.betrag.setEnabled(!this.getTransfer().ausgefuehrt());
        new KontoListener().handleEvent(null);
        return this.betrag;
    }

    public TerminInput getTermin() throws RemoteException {
        if (this.termin != null) {
            return this.termin;
        }
        this.termin = new TerminInput(this.getTransfer());
        return this.termin;
    }

    public ReminderIntervalInput getReminderInterval() throws Exception {
        if (this.interval != null) {
            return this.interval;
        }
        this.interval = new ReminderIntervalInput(this.getTransfer(), (Date)this.getTermin().getValue());
        return this.interval;
    }

    public CheckboxInput getStoreEmpfaenger() throws RemoteException {
        if (this.storeEmpfaenger != null) {
            return this.storeEmpfaenger;
        }
        this.storeEmpfaenger = new StoreAddressInput(this.getTransfer());
        return this.storeEmpfaenger;
    }

    public synchronized boolean handleStore() {
        SepaLastschrift t;
        block11: {
            t = null;
            try {
                t = this.getTransfer();
                if (!t.ausgefuehrt()) break block11;
                return true;
            }
            catch (Exception e) {
                if (t != null) {
                    try {
                        t.transactionRollback();
                    }
                    catch (Exception xe) {
                        Logger.error((String)"rollback failed", (Throwable)xe);
                    }
                }
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        t.transactionBegin();
        Double d = (Double)this.getBetrag().getValue();
        t.setBetrag(d == null ? Double.NaN : d);
        Konto k = (Konto)this.getKontoAuswahl().getValue();
        t.setKonto(k);
        t.setZweck((String)this.getZweck().getValue());
        t.setTermin((Date)this.getTermin().getValue());
        t.setEndtoEndId((String)this.getEndToEndId().getValue());
        t.setPmtInfId((String)this.getPmtInfId().getValue());
        t.setCreditorId(StringUtils.trimToNull((String)((String)this.getCreditorId().getValue())));
        t.setMandateId((String)this.getMandateId().getValue());
        t.setSignatureDate((Date)this.getSignatureDate().getValue());
        t.setSequenceType((SepaLastSequenceType)((Object)this.getSequenceType().getValue()));
        t.setType((SepaLastType)((Object)this.getType().getValue()));
        t.setTargetDate((Date)this.getTargetDate().getValue());
        String kto = (String)this.getEmpfaengerKonto().getValue();
        String name = this.getEmpfaengerName().getText();
        String bic = (String)this.getEmpfaengerBic().getValue();
        t.setGegenkontoNummer(kto);
        t.setGegenkontoName(name);
        t.setGegenkontoBLZ(bic);
        t.store();
        ReminderIntervalInput input = this.getReminderInterval();
        if (input.containsInterval()) {
            ReminderUtil.apply(t, (ReminderInterval)input.getValue(), input.getEnd());
        }
        Boolean store = (Boolean)this.getStoreEmpfaenger().getValue();
        this.aUpdate.setCreate(store);
        HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
        e.setIban(kto);
        e.setName(name);
        e.setBic(bic);
        this.aUpdate.handleAction(e);
        if (e.getID() != null) {
            this.address = e;
        }
        MetaKey.SEPA_CREDITOR_ID.set(k, t.getCreditorId());
        if (this.address != null) {
            MetaKey.SEPA_MANDATE_ID.set(this.address, t.getMandateId());
            MetaKey.SEPA_SEQUENCE_CODE.set(this.address, t.getSequenceType().name());
            MetaKey.SEPA_MANDATE_SIGDATE.set(this.address, DateUtil.DEFAULT_FORMAT.format(t.getSignatureDate()));
            MetaKey.ADDRESS_ID.set(t, this.address.getID());
        }
        t.transactionCommit();
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Auftrag gespeichert"), 0));
        MessageBus.send((String)"hibiscus.transfer.check", (Object)t);
        return true;
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            block16: {
                if (event == null) {
                    return;
                }
                if (!(event.data instanceof Address)) {
                    return;
                }
                Address a = (Address)event.data;
                SepaLastschriftControl.this.aUpdate.setAddress(a);
                try {
                    boolean haveNew;
                    SepaLastschriftControl.this.getEmpfaengerName().setText(a.getName());
                    SepaLastschriftControl.this.getEmpfaengerKonto().setValue((Object)a.getIban());
                    SepaLastschriftControl.this.getEmpfaengerBic().setValue((Object)a.getBic());
                    SepaLastschriftControl.this.getStoreEmpfaenger().setValue((Object)Boolean.FALSE);
                    try {
                        String zweck = StringUtils.trimToNull((String)((String)SepaLastschriftControl.this.getZweck().getValue()));
                        if (zweck == null) {
                            DBIterator list = SepaLastschriftControl.this.getTransfer().getList();
                            list.addFilter("empfaenger_konto = ?", new Object[]{a.getIban()});
                            list.addFilter("empfaenger_name = ?", new Object[]{a.getName()});
                            list.setOrder("order by id desc");
                            if (list.hasNext()) {
                                HibiscusTransfer t = (HibiscusTransfer)list.next();
                                SepaLastschriftControl.this.getZweck().setValue((Object)t.getZweck());
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to autocomplete subject", (Throwable)e);
                    }
                    if (!(a instanceof HibiscusAddress)) break block16;
                    HibiscusAddress addressCur = SepaLastschriftControl.this.address;
                    SepaLastschriftControl.this.address = (HibiscusAddress)a;
                    String miNew = StringUtils.trimToNull((String)MetaKey.SEPA_MANDATE_ID.get(SepaLastschriftControl.this.address));
                    String sdNew = StringUtils.trimToNull((String)MetaKey.SEPA_MANDATE_SIGDATE.get(SepaLastschriftControl.this.address));
                    String scNew = StringUtils.trimToNull((String)MetaKey.SEPA_SEQUENCE_CODE.get(SepaLastschriftControl.this.address));
                    String miCur = StringUtils.trimToNull((String)((String)SepaLastschriftControl.this.getMandateId().getValue()));
                    Date sdCur = (Date)SepaLastschriftControl.this.getSignatureDate().getValue();
                    if (miNew != null) {
                        SepaLastschriftControl.this.getMandateId().setValue((Object)miNew);
                    }
                    if (sdNew != null) {
                        SepaLastschriftControl.this.getSignatureDate().setValue((Object)sdNew);
                    }
                    if (scNew != null) {
                        try {
                            SepaLastSequenceType type = SepaLastSequenceType.valueOf(scNew);
                            SepaLastschriftControl.this.getSequenceType().setValue((Object)type);
                        }
                        catch (Exception e) {
                            Logger.error((String)("unable to determine enum value of SepaLastSequenceType for " + scNew), (Throwable)e);
                        }
                    }
                    boolean haveCur = miCur != null || sdCur != null;
                    boolean bl = haveNew = miNew != null && sdNew != null && scNew != null;
                    if (addressCur != null && !BeanUtil.equals((Object)SepaLastschriftControl.this.address, (Object)addressCur) && haveCur && !haveNew) {
                        String msg = i18n.tr("Sie haben eine neue Adresse ausgew\u00e4hlt zu der noch keine vollst\u00e4ndigen Mandatsdaten\nhinterlegt sind. Die Daten des Mandats stammen u.U. noch von der vorher ausgew\u00e4hlten\nAdresse.\n\nMandats-Referenz und Unterschriftsdatum entfernen und neu eingeben?");
                        boolean clear = Application.getCallback().askUser(msg);
                        if (clear) {
                            SepaLastschriftControl.this.getMandateId().setValue((Object)"");
                            SepaLastschriftControl.this.getSignatureDate().setValue(null);
                            SepaLastschriftControl.this.getSequenceType().setValue((Object)SepaLastSequenceType.FRST);
                            SepaLastschriftControl.this.getMandateId().focus();
                        }
                    }
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                }
                catch (Exception e) {
                    Logger.error((String)"error while choosing empfaenger", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei der Auswahl des Gegenkontos"), 1));
                }
            }
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = SepaLastschriftControl.this.getKontoAuswahl().getValue();
                if (o == null || !(o instanceof Konto)) {
                    SepaLastschriftControl.this.getBetrag().setComment("");
                    return;
                }
                Konto konto = (Konto)o;
                SepaLastschriftControl.this.getBetrag().setComment(konto.getWaehrung());
                SepaLastschriftControl.this.getTransfer().setKonto(konto);
                String creditorId = StringUtils.trimToNull((String)MetaKey.SEPA_CREDITOR_ID.get(konto));
                if (creditorId != null) {
                    SepaLastschriftControl.this.getCreditorId().setValue((Object)creditorId);
                }
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating currency", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei Ermittlung der W\u00e4hrung"));
            }
        }
    }

    private class MyKontoFilter
    extends KontoFilter {
        private KontoFilter foreign = KontoFilter.createForeign(SynchronizeJobSepaLastschrift.class);
        private boolean found = false;

        private MyKontoFilter() {
        }

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            boolean b = this.foreign.accept(konto);
            this.found |= b;
            return b;
        }
    }
}

