/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.controller;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.controller.AbstractSepaSammelTransferBuchungControl;
import de.willuhn.jameica.hbci.gui.input.AddressInput;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SepaSammelLastBuchungControl
extends AbstractSepaSammelTransferBuchungControl<SepaSammelLastBuchung> {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private SepaSammelLastBuchung buchung = null;
    private AddressInput empfName = null;
    private TextInput creditorId = null;
    private TextInput mandateId = null;
    private DateInput signature = null;
    private HibiscusAddress address = null;

    public SepaSammelLastBuchungControl(AbstractView view) {
        super(view);
    }

    @Override
    public SepaSammelLastBuchung getBuchung() {
        if (this.buchung != null) {
            return this.buchung;
        }
        this.buchung = (SepaSammelLastBuchung)this.getCurrentObject();
        return this.buchung;
    }

    @Override
    public AddressInput getEmpfaengerName() throws RemoteException {
        if (this.empfName != null) {
            return this.empfName;
        }
        SepaSammelLastBuchung s = this.getBuchung();
        try {
            String id;
            if (!s.isNewObject() && (id = StringUtils.trimToNull((String)MetaKey.ADDRESS_ID.get(s))) != null) {
                this.address = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, id);
            }
        }
        catch (ObjectNotFoundException id) {
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to restore linked address from transfer", (Throwable)re);
        }
        this.empfName = super.getEmpfaengerName();
        this.empfName.addListener(new EmpfaengerListener());
        return this.empfName;
    }

    public Input getCreditorId() throws RemoteException {
        if (this.creditorId != null) {
            return this.creditorId;
        }
        SepaSammelLastBuchung s = this.getBuchung();
        String creditorId = s.getCreditorId();
        if (StringUtils.trimToNull((String)creditorId) == null) {
            creditorId = StringUtils.trimToNull((String)MetaKey.SEPA_CREDITOR_ID.get(((SepaSammelLastschrift)s.getSammelTransfer()).getKonto()));
        }
        this.creditorId = new TextInput(creditorId, HBCIProperties.HBCI_SEPA_CREDITORID_MAXLENGTH);
        this.creditorId.setName(i18n.tr("Gl\u00e4ubiger-Identifikation"));
        this.creditorId.setValidChars(HBCIProperties.HBCI_SEPA_VALIDCHARS);
        this.creditorId.setEnabled(!((SepaSammelLastschrift)s.getSammelTransfer()).ausgefuehrt());
        this.creditorId.setMandatory(true);
        return this.creditorId;
    }

    public Input getMandateId() throws RemoteException {
        if (this.mandateId != null) {
            return this.mandateId;
        }
        SepaSammelLastBuchung s = this.getBuchung();
        this.mandateId = new TextInput(s.getMandateId(), HBCIProperties.HBCI_SEPA_MANDATEID_MAXLENGTH);
        this.mandateId.setName(i18n.tr("Mandats-Referenz"));
        this.mandateId.setValidChars(HBCIProperties.HBCI_SEPA_MANDATE_VALIDCHARS);
        this.mandateId.setEnabled(!((SepaSammelLastschrift)s.getSammelTransfer()).ausgefuehrt());
        this.mandateId.setMandatory(true);
        return this.mandateId;
    }

    public Input getSignatureDate() throws RemoteException {
        if (this.signature != null) {
            return this.signature;
        }
        SepaSammelLastBuchung s = this.getBuchung();
        this.signature = new DateInput(s.getSignatureDate(), DateUtil.DEFAULT_FORMAT);
        this.signature.setName(i18n.tr("Unterschriftsdatum des Mandats"));
        this.signature.setEnabled(!((SepaSammelLastschrift)s.getSammelTransfer()).ausgefuehrt());
        this.signature.setMandatory(true);
        return this.signature;
    }

    @Override
    public synchronized boolean handleStore() {
        SepaSammelLastschrift t;
        SepaSammelLastBuchung s;
        block10: {
            s = null;
            t = null;
            try {
                s = this.getBuchung();
                t = (SepaSammelLastschrift)s.getSammelTransfer();
                if (!t.ausgefuehrt()) break block10;
                return true;
            }
            catch (Exception e) {
                if (t != null) {
                    try {
                        t.transactionRollback();
                    }
                    catch (Exception xe) {
                        Logger.error((String)"rollback failed", (Throwable)xe);
                    }
                }
                if (e instanceof ApplicationException) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(e.getMessage(), 1));
                } else {
                    Logger.error((String)"error while saving order", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                }
                return false;
            }
        }
        s.transactionBegin();
        s.setCreditorId(StringUtils.trimToNull((String)((String)this.getCreditorId().getValue())));
        s.setMandateId((String)this.getMandateId().getValue());
        s.setSignatureDate((Date)this.getSignatureDate().getValue());
        this.store();
        Konto k = t.getKonto();
        MetaKey.SEPA_CREDITOR_ID.set(k, s.getCreditorId());
        String id = MetaKey.ADDRESS_ID.get(s);
        if (id != null) {
            this.address = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, id);
        }
        if (this.address != null) {
            MetaKey.SEPA_MANDATE_ID.set(this.address, s.getMandateId());
            MetaKey.SEPA_MANDATE_SIGDATE.set(this.address, DateUtil.DEFAULT_FORMAT.format(s.getSignatureDate()));
        }
        s.transactionCommit();
        return true;
    }

    private class EmpfaengerListener
    implements Listener {
        private EmpfaengerListener() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                return;
            }
            if (!(event.data instanceof Address)) {
                return;
            }
            Address a = (Address)event.data;
            try {
                if (a instanceof HibiscusAddress) {
                    boolean haveNew;
                    HibiscusAddress addressCur = SepaSammelLastBuchungControl.this.address;
                    SepaSammelLastBuchungControl.this.address = (HibiscusAddress)a;
                    String miNew = StringUtils.trimToNull((String)MetaKey.SEPA_MANDATE_ID.get(SepaSammelLastBuchungControl.this.address));
                    String sdNew = StringUtils.trimToNull((String)MetaKey.SEPA_MANDATE_SIGDATE.get(SepaSammelLastBuchungControl.this.address));
                    String miCur = StringUtils.trimToNull((String)((String)SepaSammelLastBuchungControl.this.getMandateId().getValue()));
                    Date sdCur = (Date)SepaSammelLastBuchungControl.this.getSignatureDate().getValue();
                    if (miNew != null) {
                        SepaSammelLastBuchungControl.this.getMandateId().setValue((Object)miNew);
                    }
                    if (sdNew != null) {
                        SepaSammelLastBuchungControl.this.getSignatureDate().setValue((Object)sdNew);
                    }
                    boolean haveCur = miCur != null || sdCur != null;
                    boolean bl = haveNew = miNew != null && sdNew != null;
                    if (addressCur != null && !BeanUtil.equals((Object)SepaSammelLastBuchungControl.this.address, (Object)addressCur) && haveCur && !haveNew) {
                        String msg = i18n.tr("Sie haben eine neue Adresse ausgew\u00e4hlt zu der noch keine vollst\u00e4ndigen Mandatsdaten\nhinterlegt sind. Die Daten des Mandats stammen u.U. noch von der vorher ausgew\u00e4hlten\nAdresse.\n\nMandats-Referenz und Unterschriftsdatum entfernen und neu eingeben?");
                        boolean clear = Application.getCallback().askUser(msg);
                        if (clear) {
                            SepaSammelLastBuchungControl.this.getMandateId().setValue((Object)"");
                            SepaSammelLastBuchungControl.this.getSignatureDate().setValue(null);
                            SepaSammelLastBuchungControl.this.getMandateId().focus();
                        }
                    }
                }
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            }
            catch (Exception e) {
                Logger.error((String)"error while choosing empfaenger", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei der Auswahl des Gegenkontos"), 1));
            }
        }
    }
}

